/* Copyright 2024, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 */
#include "unicode_data.h"
#include "ccommon.h"
#include "bisect.h"

struct UnicodeCat1Entry {
	uint32_t from, to;  // Range
	int cat1;
};

struct UnicodeMapEntry {
	uint32_t from, to;  // Map from -> to
};

/* Data generated from UnicodeData.txt
 * Sorted ascending with <from>.
 * Code at the end.
 */

static const
struct UnicodeCat1Entry g_unicode_cat1[] = {
{0x0000, 0x001f, 'C'},
{0x0020, 0x0020, 'Z'},
{0x0021, 0x0023, 'P'},
{0x0024, 0x0024, 'S'},
{0x0025, 0x002a, 'P'},
{0x002b, 0x002b, 'S'},
{0x002c, 0x002f, 'P'},
{0x0030, 0x0039, 'N'},
{0x003a, 0x003b, 'P'},
{0x003c, 0x003e, 'S'},
{0x003f, 0x0040, 'P'},
{0x0041, 0x005a, 'L'},
{0x005b, 0x005d, 'P'},
{0x005e, 0x005e, 'S'},
{0x005f, 0x005f, 'P'},
{0x0060, 0x0060, 'S'},
{0x0061, 0x007a, 'L'},
{0x007b, 0x007b, 'P'},
{0x007c, 0x007c, 'S'},
{0x007d, 0x007d, 'P'},
{0x007e, 0x007e, 'S'},
{0x007f, 0x009f, 'C'},
{0x00a0, 0x00a0, 'Z'},
{0x00a1, 0x00a1, 'P'},
{0x00a2, 0x00a6, 'S'},
{0x00a7, 0x00a7, 'P'},
{0x00a8, 0x00a9, 'S'},
{0x00aa, 0x00aa, 'L'},
{0x00ab, 0x00ab, 'P'},
{0x00ac, 0x00ac, 'S'},
{0x00ad, 0x00ad, 'C'},
{0x00ae, 0x00b1, 'S'},
{0x00b2, 0x00b3, 'N'},
{0x00b4, 0x00b4, 'S'},
{0x00b5, 0x00b5, 'L'},
{0x00b6, 0x00b7, 'P'},
{0x00b8, 0x00b8, 'S'},
{0x00b9, 0x00b9, 'N'},
{0x00ba, 0x00ba, 'L'},
{0x00bb, 0x00bb, 'P'},
{0x00bc, 0x00be, 'N'},
{0x00bf, 0x00bf, 'P'},
{0x00c0, 0x00d6, 'L'},
{0x00d7, 0x00d7, 'S'},
{0x00d8, 0x00f6, 'L'},
{0x00f7, 0x00f7, 'S'},
{0x00f8, 0x02c1, 'L'},
{0x02c2, 0x02c5, 'S'},
{0x02c6, 0x02d1, 'L'},
{0x02d2, 0x02df, 'S'},
{0x02e0, 0x02e4, 'L'},
{0x02e5, 0x02eb, 'S'},
{0x02ec, 0x02ec, 'L'},
{0x02ed, 0x02ed, 'S'},
{0x02ee, 0x02ee, 'L'},
{0x02ef, 0x02ff, 'S'},
{0x0300, 0x036f, 'M'},
{0x0370, 0x0374, 'L'},
{0x0375, 0x0375, 'S'},
{0x0376, 0x037d, 'L'},
{0x037e, 0x037e, 'P'},
{0x037f, 0x037f, 'L'},
{0x0384, 0x0385, 'S'},
{0x0386, 0x0386, 'L'},
{0x0387, 0x0387, 'P'},
{0x0388, 0x03f5, 'L'},
{0x03f6, 0x03f6, 'S'},
{0x03f7, 0x0481, 'L'},
{0x0482, 0x0482, 'S'},
{0x0483, 0x0489, 'M'},
{0x048a, 0x0559, 'L'},
{0x055a, 0x055f, 'P'},
{0x0560, 0x0588, 'L'},
{0x0589, 0x058a, 'P'},
{0x058d, 0x058f, 'S'},
{0x0591, 0x05bd, 'M'},
{0x05be, 0x05be, 'P'},
{0x05bf, 0x05bf, 'M'},
{0x05c0, 0x05c0, 'P'},
{0x05c1, 0x05c2, 'M'},
{0x05c3, 0x05c3, 'P'},
{0x05c4, 0x05c5, 'M'},
{0x05c6, 0x05c6, 'P'},
{0x05c7, 0x05c7, 'M'},
{0x05d0, 0x05f2, 'L'},
{0x05f3, 0x05f4, 'P'},
{0x0600, 0x0605, 'C'},
{0x0606, 0x0608, 'S'},
{0x0609, 0x060a, 'P'},
{0x060b, 0x060b, 'S'},
{0x060c, 0x060d, 'P'},
{0x060e, 0x060f, 'S'},
{0x0610, 0x061a, 'M'},
{0x061b, 0x061b, 'P'},
{0x061c, 0x061c, 'C'},
{0x061d, 0x061f, 'P'},
{0x0620, 0x064a, 'L'},
{0x064b, 0x065f, 'M'},
{0x0660, 0x0669, 'N'},
{0x066a, 0x066d, 'P'},
{0x066e, 0x066f, 'L'},
{0x0670, 0x0670, 'M'},
{0x0671, 0x06d3, 'L'},
{0x06d4, 0x06d4, 'P'},
{0x06d5, 0x06d5, 'L'},
{0x06d6, 0x06dc, 'M'},
{0x06dd, 0x06dd, 'C'},
{0x06de, 0x06de, 'S'},
{0x06df, 0x06e4, 'M'},
{0x06e5, 0x06e6, 'L'},
{0x06e7, 0x06e8, 'M'},
{0x06e9, 0x06e9, 'S'},
{0x06ea, 0x06ed, 'M'},
{0x06ee, 0x06ef, 'L'},
{0x06f0, 0x06f9, 'N'},
{0x06fa, 0x06fc, 'L'},
{0x06fd, 0x06fe, 'S'},
{0x06ff, 0x06ff, 'L'},
{0x0700, 0x070d, 'P'},
{0x070f, 0x070f, 'C'},
{0x0710, 0x0710, 'L'},
{0x0711, 0x0711, 'M'},
{0x0712, 0x072f, 'L'},
{0x0730, 0x074a, 'M'},
{0x074d, 0x07a5, 'L'},
{0x07a6, 0x07b0, 'M'},
{0x07b1, 0x07b1, 'L'},
{0x07c0, 0x07c9, 'N'},
{0x07ca, 0x07ea, 'L'},
{0x07eb, 0x07f3, 'M'},
{0x07f4, 0x07f5, 'L'},
{0x07f6, 0x07f6, 'S'},
{0x07f7, 0x07f9, 'P'},
{0x07fa, 0x07fa, 'L'},
{0x07fd, 0x07fd, 'M'},
{0x07fe, 0x07ff, 'S'},
{0x0800, 0x0815, 'L'},
{0x0816, 0x0819, 'M'},
{0x081a, 0x081a, 'L'},
{0x081b, 0x0823, 'M'},
{0x0824, 0x0824, 'L'},
{0x0825, 0x0827, 'M'},
{0x0828, 0x0828, 'L'},
{0x0829, 0x082d, 'M'},
{0x0830, 0x083e, 'P'},
{0x0840, 0x0858, 'L'},
{0x0859, 0x085b, 'M'},
{0x085e, 0x085e, 'P'},
{0x0860, 0x0887, 'L'},
{0x0888, 0x0888, 'S'},
{0x0889, 0x088e, 'L'},
{0x0890, 0x0891, 'C'},
{0x0897, 0x089f, 'M'},
{0x08a0, 0x08c9, 'L'},
{0x08ca, 0x08e1, 'M'},
{0x08e2, 0x08e2, 'C'},
{0x08e3, 0x0903, 'M'},
{0x0904, 0x0939, 'L'},
{0x093a, 0x093c, 'M'},
{0x093d, 0x093d, 'L'},
{0x093e, 0x094f, 'M'},
{0x0950, 0x0950, 'L'},
{0x0951, 0x0957, 'M'},
{0x0958, 0x0961, 'L'},
{0x0962, 0x0963, 'M'},
{0x0964, 0x0965, 'P'},
{0x0966, 0x096f, 'N'},
{0x0970, 0x0970, 'P'},
{0x0971, 0x0980, 'L'},
{0x0981, 0x0983, 'M'},
{0x0985, 0x09b9, 'L'},
{0x09bc, 0x09bc, 'M'},
{0x09bd, 0x09bd, 'L'},
{0x09be, 0x09cd, 'M'},
{0x09ce, 0x09ce, 'L'},
{0x09d7, 0x09d7, 'M'},
{0x09dc, 0x09e1, 'L'},
{0x09e2, 0x09e3, 'M'},
{0x09e6, 0x09ef, 'N'},
{0x09f0, 0x09f1, 'L'},
{0x09f2, 0x09f3, 'S'},
{0x09f4, 0x09f9, 'N'},
{0x09fa, 0x09fb, 'S'},
{0x09fc, 0x09fc, 'L'},
{0x09fd, 0x09fd, 'P'},
{0x09fe, 0x0a03, 'M'},
{0x0a05, 0x0a39, 'L'},
{0x0a3c, 0x0a51, 'M'},
{0x0a59, 0x0a5e, 'L'},
{0x0a66, 0x0a6f, 'N'},
{0x0a70, 0x0a71, 'M'},
{0x0a72, 0x0a74, 'L'},
{0x0a75, 0x0a75, 'M'},
{0x0a76, 0x0a76, 'P'},
{0x0a81, 0x0a83, 'M'},
{0x0a85, 0x0ab9, 'L'},
{0x0abc, 0x0abc, 'M'},
{0x0abd, 0x0abd, 'L'},
{0x0abe, 0x0acd, 'M'},
{0x0ad0, 0x0ae1, 'L'},
{0x0ae2, 0x0ae3, 'M'},
{0x0ae6, 0x0aef, 'N'},
{0x0af0, 0x0af0, 'P'},
{0x0af1, 0x0af1, 'S'},
{0x0af9, 0x0af9, 'L'},
{0x0afa, 0x0b03, 'M'},
{0x0b05, 0x0b39, 'L'},
{0x0b3c, 0x0b3c, 'M'},
{0x0b3d, 0x0b3d, 'L'},
{0x0b3e, 0x0b57, 'M'},
{0x0b5c, 0x0b61, 'L'},
{0x0b62, 0x0b63, 'M'},
{0x0b66, 0x0b6f, 'N'},
{0x0b70, 0x0b70, 'S'},
{0x0b71, 0x0b71, 'L'},
{0x0b72, 0x0b77, 'N'},
{0x0b82, 0x0b82, 'M'},
{0x0b83, 0x0bb9, 'L'},
{0x0bbe, 0x0bcd, 'M'},
{0x0bd0, 0x0bd0, 'L'},
{0x0bd7, 0x0bd7, 'M'},
{0x0be6, 0x0bf2, 'N'},
{0x0bf3, 0x0bfa, 'S'},
{0x0c00, 0x0c04, 'M'},
{0x0c05, 0x0c39, 'L'},
{0x0c3c, 0x0c3c, 'M'},
{0x0c3d, 0x0c3d, 'L'},
{0x0c3e, 0x0c56, 'M'},
{0x0c58, 0x0c61, 'L'},
{0x0c62, 0x0c63, 'M'},
{0x0c66, 0x0c6f, 'N'},
{0x0c77, 0x0c77, 'P'},
{0x0c78, 0x0c7e, 'N'},
{0x0c7f, 0x0c7f, 'S'},
{0x0c80, 0x0c80, 'L'},
{0x0c81, 0x0c83, 'M'},
{0x0c84, 0x0c84, 'P'},
{0x0c85, 0x0cb9, 'L'},
{0x0cbc, 0x0cbc, 'M'},
{0x0cbd, 0x0cbd, 'L'},
{0x0cbe, 0x0cd6, 'M'},
{0x0cdd, 0x0ce1, 'L'},
{0x0ce2, 0x0ce3, 'M'},
{0x0ce6, 0x0cef, 'N'},
{0x0cf1, 0x0cf2, 'L'},
{0x0cf3, 0x0d03, 'M'},
{0x0d04, 0x0d3a, 'L'},
{0x0d3b, 0x0d3c, 'M'},
{0x0d3d, 0x0d3d, 'L'},
{0x0d3e, 0x0d4d, 'M'},
{0x0d4e, 0x0d4e, 'L'},
{0x0d4f, 0x0d4f, 'S'},
{0x0d54, 0x0d56, 'L'},
{0x0d57, 0x0d57, 'M'},
{0x0d58, 0x0d5e, 'N'},
{0x0d5f, 0x0d61, 'L'},
{0x0d62, 0x0d63, 'M'},
{0x0d66, 0x0d78, 'N'},
{0x0d79, 0x0d79, 'S'},
{0x0d7a, 0x0d7f, 'L'},
{0x0d81, 0x0d83, 'M'},
{0x0d85, 0x0dc6, 'L'},
{0x0dca, 0x0ddf, 'M'},
{0x0de6, 0x0def, 'N'},
{0x0df2, 0x0df3, 'M'},
{0x0df4, 0x0df4, 'P'},
{0x0e01, 0x0e30, 'L'},
{0x0e31, 0x0e31, 'M'},
{0x0e32, 0x0e33, 'L'},
{0x0e34, 0x0e3a, 'M'},
{0x0e3f, 0x0e3f, 'S'},
{0x0e40, 0x0e46, 'L'},
{0x0e47, 0x0e4e, 'M'},
{0x0e4f, 0x0e4f, 'P'},
{0x0e50, 0x0e59, 'N'},
{0x0e5a, 0x0e5b, 'P'},
{0x0e81, 0x0eb0, 'L'},
{0x0eb1, 0x0eb1, 'M'},
{0x0eb2, 0x0eb3, 'L'},
{0x0eb4, 0x0ebc, 'M'},
{0x0ebd, 0x0ec6, 'L'},
{0x0ec8, 0x0ece, 'M'},
{0x0ed0, 0x0ed9, 'N'},
{0x0edc, 0x0f00, 'L'},
{0x0f01, 0x0f03, 'S'},
{0x0f04, 0x0f12, 'P'},
{0x0f13, 0x0f13, 'S'},
{0x0f14, 0x0f14, 'P'},
{0x0f15, 0x0f17, 'S'},
{0x0f18, 0x0f19, 'M'},
{0x0f1a, 0x0f1f, 'S'},
{0x0f20, 0x0f33, 'N'},
{0x0f34, 0x0f34, 'S'},
{0x0f35, 0x0f35, 'M'},
{0x0f36, 0x0f36, 'S'},
{0x0f37, 0x0f37, 'M'},
{0x0f38, 0x0f38, 'S'},
{0x0f39, 0x0f39, 'M'},
{0x0f3a, 0x0f3d, 'P'},
{0x0f3e, 0x0f3f, 'M'},
{0x0f40, 0x0f6c, 'L'},
{0x0f71, 0x0f84, 'M'},
{0x0f85, 0x0f85, 'P'},
{0x0f86, 0x0f87, 'M'},
{0x0f88, 0x0f8c, 'L'},
{0x0f8d, 0x0fbc, 'M'},
{0x0fbe, 0x0fc5, 'S'},
{0x0fc6, 0x0fc6, 'M'},
{0x0fc7, 0x0fcf, 'S'},
{0x0fd0, 0x0fd4, 'P'},
{0x0fd5, 0x0fd8, 'S'},
{0x0fd9, 0x0fda, 'P'},
{0x1000, 0x102a, 'L'},
{0x102b, 0x103e, 'M'},
{0x103f, 0x103f, 'L'},
{0x1040, 0x1049, 'N'},
{0x104a, 0x104f, 'P'},
{0x1050, 0x1055, 'L'},
{0x1056, 0x1059, 'M'},
{0x105a, 0x105d, 'L'},
{0x105e, 0x1060, 'M'},
{0x1061, 0x1061, 'L'},
{0x1062, 0x1064, 'M'},
{0x1065, 0x1066, 'L'},
{0x1067, 0x106d, 'M'},
{0x106e, 0x1070, 'L'},
{0x1071, 0x1074, 'M'},
{0x1075, 0x1081, 'L'},
{0x1082, 0x108d, 'M'},
{0x108e, 0x108e, 'L'},
{0x108f, 0x108f, 'M'},
{0x1090, 0x1099, 'N'},
{0x109a, 0x109d, 'M'},
{0x109e, 0x109f, 'S'},
{0x10a0, 0x10fa, 'L'},
{0x10fb, 0x10fb, 'P'},
{0x10fc, 0x135a, 'L'},
{0x135d, 0x135f, 'M'},
{0x1360, 0x1368, 'P'},
{0x1369, 0x137c, 'N'},
{0x1380, 0x138f, 'L'},
{0x1390, 0x1399, 'S'},
{0x13a0, 0x13fd, 'L'},
{0x1400, 0x1400, 'P'},
{0x1401, 0x166c, 'L'},
{0x166d, 0x166d, 'S'},
{0x166e, 0x166e, 'P'},
{0x166f, 0x167f, 'L'},
{0x1680, 0x1680, 'Z'},
{0x1681, 0x169a, 'L'},
{0x169b, 0x169c, 'P'},
{0x16a0, 0x16ea, 'L'},
{0x16eb, 0x16ed, 'P'},
{0x16ee, 0x16f0, 'N'},
{0x16f1, 0x1711, 'L'},
{0x1712, 0x1715, 'M'},
{0x171f, 0x1731, 'L'},
{0x1732, 0x1734, 'M'},
{0x1735, 0x1736, 'P'},
{0x1740, 0x1751, 'L'},
{0x1752, 0x1753, 'M'},
{0x1760, 0x1770, 'L'},
{0x1772, 0x1773, 'M'},
{0x1780, 0x17b3, 'L'},
{0x17b4, 0x17d3, 'M'},
{0x17d4, 0x17d6, 'P'},
{0x17d7, 0x17d7, 'L'},
{0x17d8, 0x17da, 'P'},
{0x17db, 0x17db, 'S'},
{0x17dc, 0x17dc, 'L'},
{0x17dd, 0x17dd, 'M'},
{0x17e0, 0x17f9, 'N'},
{0x1800, 0x180a, 'P'},
{0x180b, 0x180d, 'M'},
{0x180e, 0x180e, 'C'},
{0x180f, 0x180f, 'M'},
{0x1810, 0x1819, 'N'},
{0x1820, 0x1884, 'L'},
{0x1885, 0x1886, 'M'},
{0x1887, 0x18a8, 'L'},
{0x18a9, 0x18a9, 'M'},
{0x18aa, 0x191e, 'L'},
{0x1920, 0x193b, 'M'},
{0x1940, 0x1940, 'S'},
{0x1944, 0x1945, 'P'},
{0x1946, 0x194f, 'N'},
{0x1950, 0x19c9, 'L'},
{0x19d0, 0x19da, 'N'},
{0x19de, 0x19ff, 'S'},
{0x1a00, 0x1a16, 'L'},
{0x1a17, 0x1a1b, 'M'},
{0x1a1e, 0x1a1f, 'P'},
{0x1a20, 0x1a54, 'L'},
{0x1a55, 0x1a7f, 'M'},
{0x1a80, 0x1a99, 'N'},
{0x1aa0, 0x1aa6, 'P'},
{0x1aa7, 0x1aa7, 'L'},
{0x1aa8, 0x1aad, 'P'},
{0x1ab0, 0x1b04, 'M'},
{0x1b05, 0x1b33, 'L'},
{0x1b34, 0x1b44, 'M'},
{0x1b45, 0x1b4c, 'L'},
{0x1b4e, 0x1b4f, 'P'},
{0x1b50, 0x1b59, 'N'},
{0x1b5a, 0x1b60, 'P'},
{0x1b61, 0x1b6a, 'S'},
{0x1b6b, 0x1b73, 'M'},
{0x1b74, 0x1b7c, 'S'},
{0x1b7d, 0x1b7f, 'P'},
{0x1b80, 0x1b82, 'M'},
{0x1b83, 0x1ba0, 'L'},
{0x1ba1, 0x1bad, 'M'},
{0x1bae, 0x1baf, 'L'},
{0x1bb0, 0x1bb9, 'N'},
{0x1bba, 0x1be5, 'L'},
{0x1be6, 0x1bf3, 'M'},
{0x1bfc, 0x1bff, 'P'},
{0x1c00, 0x1c23, 'L'},
{0x1c24, 0x1c37, 'M'},
{0x1c3b, 0x1c3f, 'P'},
{0x1c40, 0x1c49, 'N'},
{0x1c4d, 0x1c4f, 'L'},
{0x1c50, 0x1c59, 'N'},
{0x1c5a, 0x1c7d, 'L'},
{0x1c7e, 0x1c7f, 'P'},
{0x1c80, 0x1cbf, 'L'},
{0x1cc0, 0x1cc7, 'P'},
{0x1cd0, 0x1cd2, 'M'},
{0x1cd3, 0x1cd3, 'P'},
{0x1cd4, 0x1ce8, 'M'},
{0x1ce9, 0x1cec, 'L'},
{0x1ced, 0x1ced, 'M'},
{0x1cee, 0x1cf3, 'L'},
{0x1cf4, 0x1cf4, 'M'},
{0x1cf5, 0x1cf6, 'L'},
{0x1cf7, 0x1cf9, 'M'},
{0x1cfa, 0x1dbf, 'L'},
{0x1dc0, 0x1dff, 'M'},
{0x1e00, 0x1fbc, 'L'},
{0x1fbd, 0x1fbd, 'S'},
{0x1fbe, 0x1fbe, 'L'},
{0x1fbf, 0x1fc1, 'S'},
{0x1fc2, 0x1fcc, 'L'},
{0x1fcd, 0x1fcf, 'S'},
{0x1fd0, 0x1fdb, 'L'},
{0x1fdd, 0x1fdf, 'S'},
{0x1fe0, 0x1fec, 'L'},
{0x1fed, 0x1fef, 'S'},
{0x1ff2, 0x1ffc, 'L'},
{0x1ffd, 0x1ffe, 'S'},
{0x2000, 0x200a, 'Z'},
{0x200b, 0x200f, 'C'},
{0x2010, 0x2027, 'P'},
{0x2028, 0x2029, 'Z'},
{0x202a, 0x202e, 'C'},
{0x202f, 0x202f, 'Z'},
{0x2030, 0x2043, 'P'},
{0x2044, 0x2044, 'S'},
{0x2045, 0x2051, 'P'},
{0x2052, 0x2052, 'S'},
{0x2053, 0x205e, 'P'},
{0x205f, 0x205f, 'Z'},
{0x2060, 0x206f, 'C'},
{0x2070, 0x2070, 'N'},
{0x2071, 0x2071, 'L'},
{0x2074, 0x2079, 'N'},
{0x207a, 0x207c, 'S'},
{0x207d, 0x207e, 'P'},
{0x207f, 0x207f, 'L'},
{0x2080, 0x2089, 'N'},
{0x208a, 0x208c, 'S'},
{0x208d, 0x208e, 'P'},
{0x2090, 0x209c, 'L'},
{0x20a0, 0x20c0, 'S'},
{0x20d0, 0x20f0, 'M'},
{0x2100, 0x2101, 'S'},
{0x2102, 0x2102, 'L'},
{0x2103, 0x2106, 'S'},
{0x2107, 0x2107, 'L'},
{0x2108, 0x2109, 'S'},
{0x210a, 0x2113, 'L'},
{0x2114, 0x2114, 'S'},
{0x2115, 0x2115, 'L'},
{0x2116, 0x2118, 'S'},
{0x2119, 0x211d, 'L'},
{0x211e, 0x2123, 'S'},
{0x2124, 0x2124, 'L'},
{0x2125, 0x2125, 'S'},
{0x2126, 0x2126, 'L'},
{0x2127, 0x2127, 'S'},
{0x2128, 0x2128, 'L'},
{0x2129, 0x2129, 'S'},
{0x212a, 0x212d, 'L'},
{0x212e, 0x212e, 'S'},
{0x212f, 0x2139, 'L'},
{0x213a, 0x213b, 'S'},
{0x213c, 0x213f, 'L'},
{0x2140, 0x2144, 'S'},
{0x2145, 0x2149, 'L'},
{0x214a, 0x214d, 'S'},
{0x214e, 0x214e, 'L'},
{0x214f, 0x214f, 'S'},
{0x2150, 0x2182, 'N'},
{0x2183, 0x2184, 'L'},
{0x2185, 0x2189, 'N'},
{0x218a, 0x2307, 'S'},
{0x2308, 0x230b, 'P'},
{0x230c, 0x2328, 'S'},
{0x2329, 0x232a, 'P'},
{0x232b, 0x244a, 'S'},
{0x2460, 0x249b, 'N'},
{0x249c, 0x24e9, 'S'},
{0x24ea, 0x24ff, 'N'},
{0x2500, 0x2767, 'S'},
{0x2768, 0x2775, 'P'},
{0x2776, 0x2793, 'N'},
{0x2794, 0x27c4, 'S'},
{0x27c5, 0x27c6, 'P'},
{0x27c7, 0x27e5, 'S'},
{0x27e6, 0x27ef, 'P'},
{0x27f0, 0x2982, 'S'},
{0x2983, 0x2998, 'P'},
{0x2999, 0x29d7, 'S'},
{0x29d8, 0x29db, 'P'},
{0x29dc, 0x29fb, 'S'},
{0x29fc, 0x29fd, 'P'},
{0x29fe, 0x2bff, 'S'},
{0x2c00, 0x2ce4, 'L'},
{0x2ce5, 0x2cea, 'S'},
{0x2ceb, 0x2cee, 'L'},
{0x2cef, 0x2cf1, 'M'},
{0x2cf2, 0x2cf3, 'L'},
{0x2cf9, 0x2cfc, 'P'},
{0x2cfd, 0x2cfd, 'N'},
{0x2cfe, 0x2cff, 'P'},
{0x2d00, 0x2d6f, 'L'},
{0x2d70, 0x2d70, 'P'},
{0x2d7f, 0x2d7f, 'M'},
{0x2d80, 0x2dde, 'L'},
{0x2de0, 0x2dff, 'M'},
{0x2e00, 0x2e2e, 'P'},
{0x2e2f, 0x2e2f, 'L'},
{0x2e30, 0x2e4f, 'P'},
{0x2e50, 0x2e51, 'S'},
{0x2e52, 0x2e5d, 'P'},
{0x2e80, 0x2fff, 'S'},
{0x3000, 0x3000, 'Z'},
{0x3001, 0x3003, 'P'},
{0x3004, 0x3004, 'S'},
{0x3005, 0x3006, 'L'},
{0x3007, 0x3007, 'N'},
{0x3008, 0x3011, 'P'},
{0x3012, 0x3013, 'S'},
{0x3014, 0x301f, 'P'},
{0x3020, 0x3020, 'S'},
{0x3021, 0x3029, 'N'},
{0x302a, 0x302f, 'M'},
{0x3030, 0x3030, 'P'},
{0x3031, 0x3035, 'L'},
{0x3036, 0x3037, 'S'},
{0x3038, 0x303a, 'N'},
{0x303b, 0x303c, 'L'},
{0x303d, 0x303d, 'P'},
{0x303e, 0x303f, 'S'},
{0x3041, 0x3096, 'L'},
{0x3099, 0x309a, 'M'},
{0x309b, 0x309c, 'S'},
{0x309d, 0x309f, 'L'},
{0x30a0, 0x30a0, 'P'},
{0x30a1, 0x30fa, 'L'},
{0x30fb, 0x30fb, 'P'},
{0x30fc, 0x318e, 'L'},
{0x3190, 0x3191, 'S'},
{0x3192, 0x3195, 'N'},
{0x3196, 0x319f, 'S'},
{0x31a0, 0x31bf, 'L'},
{0x31c0, 0x31ef, 'S'},
{0x31f0, 0x31ff, 'L'},
{0x3200, 0x321e, 'S'},
{0x3220, 0x3229, 'N'},
{0x322a, 0x3247, 'S'},
{0x3248, 0x324f, 'N'},
{0x3250, 0x3250, 'S'},
{0x3251, 0x325f, 'N'},
{0x3260, 0x327f, 'S'},
{0x3280, 0x3289, 'N'},
{0x328a, 0x32b0, 'S'},
{0x32b1, 0x32bf, 'N'},
{0x32c0, 0x33ff, 'S'},
{0x3400, 0x4dbf, 'L'},
{0x4dc0, 0x4dff, 'S'},
{0x4e00, 0xa48c, 'L'},
{0xa490, 0xa4c6, 'S'},
{0xa4d0, 0xa4fd, 'L'},
{0xa4fe, 0xa4ff, 'P'},
{0xa500, 0xa60c, 'L'},
{0xa60d, 0xa60f, 'P'},
{0xa610, 0xa61f, 'L'},
{0xa620, 0xa629, 'N'},
{0xa62a, 0xa66e, 'L'},
{0xa66f, 0xa672, 'M'},
{0xa673, 0xa673, 'P'},
{0xa674, 0xa67d, 'M'},
{0xa67e, 0xa67e, 'P'},
{0xa67f, 0xa69d, 'L'},
{0xa69e, 0xa69f, 'M'},
{0xa6a0, 0xa6e5, 'L'},
{0xa6e6, 0xa6ef, 'N'},
{0xa6f0, 0xa6f1, 'M'},
{0xa6f2, 0xa6f7, 'P'},
{0xa700, 0xa716, 'S'},
{0xa717, 0xa71f, 'L'},
{0xa720, 0xa721, 'S'},
{0xa722, 0xa788, 'L'},
{0xa789, 0xa78a, 'S'},
{0xa78b, 0xa801, 'L'},
{0xa802, 0xa802, 'M'},
{0xa803, 0xa805, 'L'},
{0xa806, 0xa806, 'M'},
{0xa807, 0xa80a, 'L'},
{0xa80b, 0xa80b, 'M'},
{0xa80c, 0xa822, 'L'},
{0xa823, 0xa827, 'M'},
{0xa828, 0xa82b, 'S'},
{0xa82c, 0xa82c, 'M'},
{0xa830, 0xa835, 'N'},
{0xa836, 0xa839, 'S'},
{0xa840, 0xa873, 'L'},
{0xa874, 0xa877, 'P'},
{0xa880, 0xa881, 'M'},
{0xa882, 0xa8b3, 'L'},
{0xa8b4, 0xa8c5, 'M'},
{0xa8ce, 0xa8cf, 'P'},
{0xa8d0, 0xa8d9, 'N'},
{0xa8e0, 0xa8f1, 'M'},
{0xa8f2, 0xa8f7, 'L'},
{0xa8f8, 0xa8fa, 'P'},
{0xa8fb, 0xa8fb, 'L'},
{0xa8fc, 0xa8fc, 'P'},
{0xa8fd, 0xa8fe, 'L'},
{0xa8ff, 0xa8ff, 'M'},
{0xa900, 0xa909, 'N'},
{0xa90a, 0xa925, 'L'},
{0xa926, 0xa92d, 'M'},
{0xa92e, 0xa92f, 'P'},
{0xa930, 0xa946, 'L'},
{0xa947, 0xa953, 'M'},
{0xa95f, 0xa95f, 'P'},
{0xa960, 0xa97c, 'L'},
{0xa980, 0xa983, 'M'},
{0xa984, 0xa9b2, 'L'},
{0xa9b3, 0xa9c0, 'M'},
{0xa9c1, 0xa9cd, 'P'},
{0xa9cf, 0xa9cf, 'L'},
{0xa9d0, 0xa9d9, 'N'},
{0xa9de, 0xa9df, 'P'},
{0xa9e0, 0xa9e4, 'L'},
{0xa9e5, 0xa9e5, 'M'},
{0xa9e6, 0xa9ef, 'L'},
{0xa9f0, 0xa9f9, 'N'},
{0xa9fa, 0xaa28, 'L'},
{0xaa29, 0xaa36, 'M'},
{0xaa40, 0xaa42, 'L'},
{0xaa43, 0xaa43, 'M'},
{0xaa44, 0xaa4b, 'L'},
{0xaa4c, 0xaa4d, 'M'},
{0xaa50, 0xaa59, 'N'},
{0xaa5c, 0xaa5f, 'P'},
{0xaa60, 0xaa76, 'L'},
{0xaa77, 0xaa79, 'S'},
{0xaa7a, 0xaa7a, 'L'},
{0xaa7b, 0xaa7d, 'M'},
{0xaa7e, 0xaaaf, 'L'},
{0xaab0, 0xaab0, 'M'},
{0xaab1, 0xaab1, 'L'},
{0xaab2, 0xaab4, 'M'},
{0xaab5, 0xaab6, 'L'},
{0xaab7, 0xaab8, 'M'},
{0xaab9, 0xaabd, 'L'},
{0xaabe, 0xaabf, 'M'},
{0xaac0, 0xaac0, 'L'},
{0xaac1, 0xaac1, 'M'},
{0xaac2, 0xaadd, 'L'},
{0xaade, 0xaadf, 'P'},
{0xaae0, 0xaaea, 'L'},
{0xaaeb, 0xaaef, 'M'},
{0xaaf0, 0xaaf1, 'P'},
{0xaaf2, 0xaaf4, 'L'},
{0xaaf5, 0xaaf6, 'M'},
{0xab01, 0xab5a, 'L'},
{0xab5b, 0xab5b, 'S'},
{0xab5c, 0xab69, 'L'},
{0xab6a, 0xab6b, 'S'},
{0xab70, 0xabe2, 'L'},
{0xabe3, 0xabea, 'M'},
{0xabeb, 0xabeb, 'P'},
{0xabec, 0xabed, 'M'},
{0xabf0, 0xabf9, 'N'},
{0xac00, 0xd7fb, 'L'},
{0xd800, 0xf8ff, 'C'},
{0xf900, 0xfb1d, 'L'},
{0xfb1e, 0xfb1e, 'M'},
{0xfb1f, 0xfb28, 'L'},
{0xfb29, 0xfb29, 'S'},
{0xfb2a, 0xfbb1, 'L'},
{0xfbb2, 0xfbc2, 'S'},
{0xfbd3, 0xfd3d, 'L'},
{0xfd3e, 0xfd3f, 'P'},
{0xfd40, 0xfd4f, 'S'},
{0xfd50, 0xfdc7, 'L'},
{0xfdcf, 0xfdcf, 'S'},
{0xfdf0, 0xfdfb, 'L'},
{0xfdfc, 0xfdff, 'S'},
{0xfe00, 0xfe0f, 'M'},
{0xfe10, 0xfe19, 'P'},
{0xfe20, 0xfe2f, 'M'},
{0xfe30, 0xfe61, 'P'},
{0xfe62, 0xfe62, 'S'},
{0xfe63, 0xfe63, 'P'},
{0xfe64, 0xfe66, 'S'},
{0xfe68, 0xfe68, 'P'},
{0xfe69, 0xfe69, 'S'},
{0xfe6a, 0xfe6b, 'P'},
{0xfe70, 0xfefc, 'L'},
{0xfeff, 0xfeff, 'C'},
{0xff01, 0xff03, 'P'},
{0xff04, 0xff04, 'S'},
{0xff05, 0xff0a, 'P'},
{0xff0b, 0xff0b, 'S'},
{0xff0c, 0xff0f, 'P'},
{0xff10, 0xff19, 'N'},
{0xff1a, 0xff1b, 'P'},
{0xff1c, 0xff1e, 'S'},
{0xff1f, 0xff20, 'P'},
{0xff21, 0xff3a, 'L'},
{0xff3b, 0xff3d, 'P'},
{0xff3e, 0xff3e, 'S'},
{0xff3f, 0xff3f, 'P'},
{0xff40, 0xff40, 'S'},
{0xff41, 0xff5a, 'L'},
{0xff5b, 0xff5b, 'P'},
{0xff5c, 0xff5c, 'S'},
{0xff5d, 0xff5d, 'P'},
{0xff5e, 0xff5e, 'S'},
{0xff5f, 0xff65, 'P'},
{0xff66, 0xffdc, 'L'},
{0xffe0, 0xffee, 'S'},
{0xfff9, 0xfffb, 'C'},
{0xfffc, 0xfffd, 'S'},
{0x10000, 0x100fa, 'L'},
{0x10100, 0x10102, 'P'},
{0x10107, 0x10133, 'N'},
{0x10137, 0x1013f, 'S'},
{0x10140, 0x10178, 'N'},
{0x10179, 0x10189, 'S'},
{0x1018a, 0x1018b, 'N'},
{0x1018c, 0x101fc, 'S'},
{0x101fd, 0x101fd, 'M'},
{0x10280, 0x102d0, 'L'},
{0x102e0, 0x102e0, 'M'},
{0x102e1, 0x102fb, 'N'},
{0x10300, 0x1031f, 'L'},
{0x10320, 0x10323, 'N'},
{0x1032d, 0x10340, 'L'},
{0x10341, 0x10341, 'N'},
{0x10342, 0x10349, 'L'},
{0x1034a, 0x1034a, 'N'},
{0x10350, 0x10375, 'L'},
{0x10376, 0x1037a, 'M'},
{0x10380, 0x1039d, 'L'},
{0x1039f, 0x1039f, 'P'},
{0x103a0, 0x103cf, 'L'},
{0x103d0, 0x103d0, 'P'},
{0x103d1, 0x103d5, 'N'},
{0x10400, 0x1049d, 'L'},
{0x104a0, 0x104a9, 'N'},
{0x104b0, 0x10563, 'L'},
{0x1056f, 0x1056f, 'P'},
{0x10570, 0x10855, 'L'},
{0x10857, 0x10857, 'P'},
{0x10858, 0x1085f, 'N'},
{0x10860, 0x10876, 'L'},
{0x10877, 0x10878, 'S'},
{0x10879, 0x1087f, 'N'},
{0x10880, 0x1089e, 'L'},
{0x108a7, 0x108af, 'N'},
{0x108e0, 0x108f5, 'L'},
{0x108fb, 0x108ff, 'N'},
{0x10900, 0x10915, 'L'},
{0x10916, 0x1091b, 'N'},
{0x1091f, 0x1091f, 'P'},
{0x10920, 0x10939, 'L'},
{0x1093f, 0x1093f, 'P'},
{0x10980, 0x109b7, 'L'},
{0x109bc, 0x109bd, 'N'},
{0x109be, 0x109bf, 'L'},
{0x109c0, 0x109ff, 'N'},
{0x10a00, 0x10a00, 'L'},
{0x10a01, 0x10a0f, 'M'},
{0x10a10, 0x10a35, 'L'},
{0x10a38, 0x10a3f, 'M'},
{0x10a40, 0x10a48, 'N'},
{0x10a50, 0x10a58, 'P'},
{0x10a60, 0x10a7c, 'L'},
{0x10a7d, 0x10a7e, 'N'},
{0x10a7f, 0x10a7f, 'P'},
{0x10a80, 0x10a9c, 'L'},
{0x10a9d, 0x10a9f, 'N'},
{0x10ac0, 0x10ac7, 'L'},
{0x10ac8, 0x10ac8, 'S'},
{0x10ac9, 0x10ae4, 'L'},
{0x10ae5, 0x10ae6, 'M'},
{0x10aeb, 0x10aef, 'N'},
{0x10af0, 0x10af6, 'P'},
{0x10b00, 0x10b35, 'L'},
{0x10b39, 0x10b3f, 'P'},
{0x10b40, 0x10b55, 'L'},
{0x10b58, 0x10b5f, 'N'},
{0x10b60, 0x10b72, 'L'},
{0x10b78, 0x10b7f, 'N'},
{0x10b80, 0x10b91, 'L'},
{0x10b99, 0x10b9c, 'P'},
{0x10ba9, 0x10baf, 'N'},
{0x10c00, 0x10cf2, 'L'},
{0x10cfa, 0x10cff, 'N'},
{0x10d00, 0x10d23, 'L'},
{0x10d24, 0x10d27, 'M'},
{0x10d30, 0x10d49, 'N'},
{0x10d4a, 0x10d65, 'L'},
{0x10d69, 0x10d6d, 'M'},
{0x10d6e, 0x10d6e, 'P'},
{0x10d6f, 0x10d85, 'L'},
{0x10d8e, 0x10d8f, 'S'},
{0x10e60, 0x10e7e, 'N'},
{0x10e80, 0x10ea9, 'L'},
{0x10eab, 0x10eac, 'M'},
{0x10ead, 0x10ead, 'P'},
{0x10eb0, 0x10ec4, 'L'},
{0x10efc, 0x10eff, 'M'},
{0x10f00, 0x10f1c, 'L'},
{0x10f1d, 0x10f26, 'N'},
{0x10f27, 0x10f45, 'L'},
{0x10f46, 0x10f50, 'M'},
{0x10f51, 0x10f54, 'N'},
{0x10f55, 0x10f59, 'P'},
{0x10f70, 0x10f81, 'L'},
{0x10f82, 0x10f85, 'M'},
{0x10f86, 0x10f89, 'P'},
{0x10fb0, 0x10fc4, 'L'},
{0x10fc5, 0x10fcb, 'N'},
{0x10fe0, 0x10ff6, 'L'},
{0x11000, 0x11002, 'M'},
{0x11003, 0x11037, 'L'},
{0x11038, 0x11046, 'M'},
{0x11047, 0x1104d, 'P'},
{0x11052, 0x1106f, 'N'},
{0x11070, 0x11070, 'M'},
{0x11071, 0x11072, 'L'},
{0x11073, 0x11074, 'M'},
{0x11075, 0x11075, 'L'},
{0x1107f, 0x11082, 'M'},
{0x11083, 0x110af, 'L'},
{0x110b0, 0x110ba, 'M'},
{0x110bb, 0x110bc, 'P'},
{0x110bd, 0x110bd, 'C'},
{0x110be, 0x110c1, 'P'},
{0x110c2, 0x110c2, 'M'},
{0x110cd, 0x110cd, 'C'},
{0x110d0, 0x110e8, 'L'},
{0x110f0, 0x110f9, 'N'},
{0x11100, 0x11102, 'M'},
{0x11103, 0x11126, 'L'},
{0x11127, 0x11134, 'M'},
{0x11136, 0x1113f, 'N'},
{0x11140, 0x11143, 'P'},
{0x11144, 0x11144, 'L'},
{0x11145, 0x11146, 'M'},
{0x11147, 0x11172, 'L'},
{0x11173, 0x11173, 'M'},
{0x11174, 0x11175, 'P'},
{0x11176, 0x11176, 'L'},
{0x11180, 0x11182, 'M'},
{0x11183, 0x111b2, 'L'},
{0x111b3, 0x111c0, 'M'},
{0x111c1, 0x111c4, 'L'},
{0x111c5, 0x111c8, 'P'},
{0x111c9, 0x111cc, 'M'},
{0x111cd, 0x111cd, 'P'},
{0x111ce, 0x111cf, 'M'},
{0x111d0, 0x111d9, 'N'},
{0x111da, 0x111da, 'L'},
{0x111db, 0x111db, 'P'},
{0x111dc, 0x111dc, 'L'},
{0x111dd, 0x111df, 'P'},
{0x111e1, 0x111f4, 'N'},
{0x11200, 0x1122b, 'L'},
{0x1122c, 0x11237, 'M'},
{0x11238, 0x1123d, 'P'},
{0x1123e, 0x1123e, 'M'},
{0x1123f, 0x11240, 'L'},
{0x11241, 0x11241, 'M'},
{0x11280, 0x112a8, 'L'},
{0x112a9, 0x112a9, 'P'},
{0x112b0, 0x112de, 'L'},
{0x112df, 0x112ea, 'M'},
{0x112f0, 0x112f9, 'N'},
{0x11300, 0x11303, 'M'},
{0x11305, 0x11339, 'L'},
{0x1133b, 0x1133c, 'M'},
{0x1133d, 0x1133d, 'L'},
{0x1133e, 0x1134d, 'M'},
{0x11350, 0x11350, 'L'},
{0x11357, 0x11357, 'M'},
{0x1135d, 0x11361, 'L'},
{0x11362, 0x11374, 'M'},
{0x11380, 0x113b7, 'L'},
{0x113b8, 0x113d0, 'M'},
{0x113d1, 0x113d1, 'L'},
{0x113d2, 0x113d2, 'M'},
{0x113d3, 0x113d3, 'L'},
{0x113d4, 0x113d8, 'P'},
{0x113e1, 0x113e2, 'M'},
{0x11400, 0x11434, 'L'},
{0x11435, 0x11446, 'M'},
{0x11447, 0x1144a, 'L'},
{0x1144b, 0x1144f, 'P'},
{0x11450, 0x11459, 'N'},
{0x1145a, 0x1145d, 'P'},
{0x1145e, 0x1145e, 'M'},
{0x1145f, 0x114af, 'L'},
{0x114b0, 0x114c3, 'M'},
{0x114c4, 0x114c5, 'L'},
{0x114c6, 0x114c6, 'P'},
{0x114c7, 0x114c7, 'L'},
{0x114d0, 0x114d9, 'N'},
{0x11580, 0x115ae, 'L'},
{0x115af, 0x115c0, 'M'},
{0x115c1, 0x115d7, 'P'},
{0x115d8, 0x115db, 'L'},
{0x115dc, 0x115dd, 'M'},
{0x11600, 0x1162f, 'L'},
{0x11630, 0x11640, 'M'},
{0x11641, 0x11643, 'P'},
{0x11644, 0x11644, 'L'},
{0x11650, 0x11659, 'N'},
{0x11660, 0x1166c, 'P'},
{0x11680, 0x116aa, 'L'},
{0x116ab, 0x116b7, 'M'},
{0x116b8, 0x116b8, 'L'},
{0x116b9, 0x116b9, 'P'},
{0x116c0, 0x116e3, 'N'},
{0x11700, 0x1171a, 'L'},
{0x1171d, 0x1172b, 'M'},
{0x11730, 0x1173b, 'N'},
{0x1173c, 0x1173e, 'P'},
{0x1173f, 0x1173f, 'S'},
{0x11740, 0x1182b, 'L'},
{0x1182c, 0x1183a, 'M'},
{0x1183b, 0x1183b, 'P'},
{0x118a0, 0x118df, 'L'},
{0x118e0, 0x118f2, 'N'},
{0x118ff, 0x1192f, 'L'},
{0x11930, 0x1193e, 'M'},
{0x1193f, 0x1193f, 'L'},
{0x11940, 0x11940, 'M'},
{0x11941, 0x11941, 'L'},
{0x11942, 0x11943, 'M'},
{0x11944, 0x11946, 'P'},
{0x11950, 0x11959, 'N'},
{0x119a0, 0x119d0, 'L'},
{0x119d1, 0x119e0, 'M'},
{0x119e1, 0x119e1, 'L'},
{0x119e2, 0x119e2, 'P'},
{0x119e3, 0x119e3, 'L'},
{0x119e4, 0x119e4, 'M'},
{0x11a00, 0x11a00, 'L'},
{0x11a01, 0x11a0a, 'M'},
{0x11a0b, 0x11a32, 'L'},
{0x11a33, 0x11a39, 'M'},
{0x11a3a, 0x11a3a, 'L'},
{0x11a3b, 0x11a3e, 'M'},
{0x11a3f, 0x11a46, 'P'},
{0x11a47, 0x11a47, 'M'},
{0x11a50, 0x11a50, 'L'},
{0x11a51, 0x11a5b, 'M'},
{0x11a5c, 0x11a89, 'L'},
{0x11a8a, 0x11a99, 'M'},
{0x11a9a, 0x11a9c, 'P'},
{0x11a9d, 0x11a9d, 'L'},
{0x11a9e, 0x11aa2, 'P'},
{0x11ab0, 0x11af8, 'L'},
{0x11b00, 0x11b09, 'P'},
{0x11bc0, 0x11be0, 'L'},
{0x11be1, 0x11be1, 'P'},
{0x11bf0, 0x11bf9, 'N'},
{0x11c00, 0x11c2e, 'L'},
{0x11c2f, 0x11c3f, 'M'},
{0x11c40, 0x11c40, 'L'},
{0x11c41, 0x11c45, 'P'},
{0x11c50, 0x11c6c, 'N'},
{0x11c70, 0x11c71, 'P'},
{0x11c72, 0x11c8f, 'L'},
{0x11c92, 0x11cb6, 'M'},
{0x11d00, 0x11d30, 'L'},
{0x11d31, 0x11d45, 'M'},
{0x11d46, 0x11d46, 'L'},
{0x11d47, 0x11d47, 'M'},
{0x11d50, 0x11d59, 'N'},
{0x11d60, 0x11d89, 'L'},
{0x11d8a, 0x11d97, 'M'},
{0x11d98, 0x11d98, 'L'},
{0x11da0, 0x11da9, 'N'},
{0x11ee0, 0x11ef2, 'L'},
{0x11ef3, 0x11ef6, 'M'},
{0x11ef7, 0x11ef8, 'P'},
{0x11f00, 0x11f01, 'M'},
{0x11f02, 0x11f02, 'L'},
{0x11f03, 0x11f03, 'M'},
{0x11f04, 0x11f33, 'L'},
{0x11f34, 0x11f42, 'M'},
{0x11f43, 0x11f4f, 'P'},
{0x11f50, 0x11f59, 'N'},
{0x11f5a, 0x11f5a, 'M'},
{0x11fb0, 0x11fb0, 'L'},
{0x11fc0, 0x11fd4, 'N'},
{0x11fd5, 0x11ff1, 'S'},
{0x11fff, 0x11fff, 'P'},
{0x12000, 0x12399, 'L'},
{0x12400, 0x1246e, 'N'},
{0x12470, 0x12474, 'P'},
{0x12480, 0x12ff0, 'L'},
{0x12ff1, 0x12ff2, 'P'},
{0x13000, 0x1342f, 'L'},
{0x13430, 0x1343f, 'C'},
{0x13440, 0x13440, 'M'},
{0x13441, 0x13446, 'L'},
{0x13447, 0x13455, 'M'},
{0x13460, 0x1611d, 'L'},
{0x1611e, 0x1612f, 'M'},
{0x16130, 0x16139, 'N'},
{0x16800, 0x16a5e, 'L'},
{0x16a60, 0x16a69, 'N'},
{0x16a6e, 0x16a6f, 'P'},
{0x16a70, 0x16abe, 'L'},
{0x16ac0, 0x16ac9, 'N'},
{0x16ad0, 0x16aed, 'L'},
{0x16af0, 0x16af4, 'M'},
{0x16af5, 0x16af5, 'P'},
{0x16b00, 0x16b2f, 'L'},
{0x16b30, 0x16b36, 'M'},
{0x16b37, 0x16b3b, 'P'},
{0x16b3c, 0x16b3f, 'S'},
{0x16b40, 0x16b43, 'L'},
{0x16b44, 0x16b44, 'P'},
{0x16b45, 0x16b45, 'S'},
{0x16b50, 0x16b61, 'N'},
{0x16b63, 0x16d6c, 'L'},
{0x16d6d, 0x16d6f, 'P'},
{0x16d70, 0x16d79, 'N'},
{0x16e40, 0x16e7f, 'L'},
{0x16e80, 0x16e96, 'N'},
{0x16e97, 0x16e9a, 'P'},
{0x16f00, 0x16f4a, 'L'},
{0x16f4f, 0x16f4f, 'M'},
{0x16f50, 0x16f50, 'L'},
{0x16f51, 0x16f92, 'M'},
{0x16f93, 0x16fe1, 'L'},
{0x16fe2, 0x16fe2, 'P'},
{0x16fe3, 0x16fe3, 'L'},
{0x16fe4, 0x16ff1, 'M'},
{0x17000, 0x1bc99, 'L'},
{0x1bc9c, 0x1bc9c, 'S'},
{0x1bc9d, 0x1bc9e, 'M'},
{0x1bc9f, 0x1bc9f, 'P'},
{0x1bca0, 0x1bca3, 'C'},
{0x1cc00, 0x1ccef, 'S'},
{0x1ccf0, 0x1ccf9, 'N'},
{0x1cd00, 0x1ceb3, 'S'},
{0x1cf00, 0x1cf46, 'M'},
{0x1cf50, 0x1d164, 'S'},
{0x1d165, 0x1d169, 'M'},
{0x1d16a, 0x1d16c, 'S'},
{0x1d16d, 0x1d172, 'M'},
{0x1d173, 0x1d17a, 'C'},
{0x1d17b, 0x1d182, 'M'},
{0x1d183, 0x1d184, 'S'},
{0x1d185, 0x1d18b, 'M'},
{0x1d18c, 0x1d1a9, 'S'},
{0x1d1aa, 0x1d1ad, 'M'},
{0x1d1ae, 0x1d241, 'S'},
{0x1d242, 0x1d244, 'M'},
{0x1d245, 0x1d245, 'S'},
{0x1d2c0, 0x1d2f3, 'N'},
{0x1d300, 0x1d356, 'S'},
{0x1d360, 0x1d378, 'N'},
{0x1d400, 0x1d6c0, 'L'},
{0x1d6c1, 0x1d6c1, 'S'},
{0x1d6c2, 0x1d6da, 'L'},
{0x1d6db, 0x1d6db, 'S'},
{0x1d6dc, 0x1d6fa, 'L'},
{0x1d6fb, 0x1d6fb, 'S'},
{0x1d6fc, 0x1d714, 'L'},
{0x1d715, 0x1d715, 'S'},
{0x1d716, 0x1d734, 'L'},
{0x1d735, 0x1d735, 'S'},
{0x1d736, 0x1d74e, 'L'},
{0x1d74f, 0x1d74f, 'S'},
{0x1d750, 0x1d76e, 'L'},
{0x1d76f, 0x1d76f, 'S'},
{0x1d770, 0x1d788, 'L'},
{0x1d789, 0x1d789, 'S'},
{0x1d78a, 0x1d7a8, 'L'},
{0x1d7a9, 0x1d7a9, 'S'},
{0x1d7aa, 0x1d7c2, 'L'},
{0x1d7c3, 0x1d7c3, 'S'},
{0x1d7c4, 0x1d7cb, 'L'},
{0x1d7ce, 0x1d7ff, 'N'},
{0x1d800, 0x1d9ff, 'S'},
{0x1da00, 0x1da36, 'M'},
{0x1da37, 0x1da3a, 'S'},
{0x1da3b, 0x1da6c, 'M'},
{0x1da6d, 0x1da74, 'S'},
{0x1da75, 0x1da75, 'M'},
{0x1da76, 0x1da83, 'S'},
{0x1da84, 0x1da84, 'M'},
{0x1da85, 0x1da86, 'S'},
{0x1da87, 0x1da8b, 'P'},
{0x1da9b, 0x1daaf, 'M'},
{0x1df00, 0x1df2a, 'L'},
{0x1e000, 0x1e02a, 'M'},
{0x1e030, 0x1e06d, 'L'},
{0x1e08f, 0x1e08f, 'M'},
{0x1e100, 0x1e12c, 'L'},
{0x1e130, 0x1e136, 'M'},
{0x1e137, 0x1e13d, 'L'},
{0x1e140, 0x1e149, 'N'},
{0x1e14e, 0x1e14e, 'L'},
{0x1e14f, 0x1e14f, 'S'},
{0x1e290, 0x1e2ad, 'L'},
{0x1e2ae, 0x1e2ae, 'M'},
{0x1e2c0, 0x1e2eb, 'L'},
{0x1e2ec, 0x1e2ef, 'M'},
{0x1e2f0, 0x1e2f9, 'N'},
{0x1e2ff, 0x1e2ff, 'S'},
{0x1e4d0, 0x1e4eb, 'L'},
{0x1e4ec, 0x1e4ef, 'M'},
{0x1e4f0, 0x1e4f9, 'N'},
{0x1e5d0, 0x1e5ed, 'L'},
{0x1e5ee, 0x1e5ef, 'M'},
{0x1e5f0, 0x1e5f0, 'L'},
{0x1e5f1, 0x1e5fa, 'N'},
{0x1e5ff, 0x1e5ff, 'P'},
{0x1e7e0, 0x1e8c4, 'L'},
{0x1e8c7, 0x1e8cf, 'N'},
{0x1e8d0, 0x1e8d6, 'M'},
{0x1e900, 0x1e943, 'L'},
{0x1e944, 0x1e94a, 'M'},
{0x1e94b, 0x1e94b, 'L'},
{0x1e950, 0x1e959, 'N'},
{0x1e95e, 0x1e95f, 'P'},
{0x1ec71, 0x1ecab, 'N'},
{0x1ecac, 0x1ecac, 'S'},
{0x1ecad, 0x1ecaf, 'N'},
{0x1ecb0, 0x1ecb0, 'S'},
{0x1ecb1, 0x1ed2d, 'N'},
{0x1ed2e, 0x1ed2e, 'S'},
{0x1ed2f, 0x1ed3d, 'N'},
{0x1ee00, 0x1eebb, 'L'},
{0x1eef0, 0x1f0f5, 'S'},
{0x1f100, 0x1f10c, 'N'},
{0x1f10d, 0x1fbef, 'S'},
{0x1fbf0, 0x1fbf9, 'N'},
{0x20000, 0x323af, 'L'},
{0xe0001, 0xe007f, 'C'},
{0xe0100, 0xe01ef, 'M'},
{0xf0000, 0x10fffd, 'C'},
};

static const
struct UnicodeMapEntry g_unicode_upper[] = {
{0x0061, 0x0041},
{0x0062, 0x0042},
{0x0063, 0x0043},
{0x0064, 0x0044},
{0x0065, 0x0045},
{0x0066, 0x0046},
{0x0067, 0x0047},
{0x0068, 0x0048},
{0x0069, 0x0049},
{0x006A, 0x004A},
{0x006B, 0x004B},
{0x006C, 0x004C},
{0x006D, 0x004D},
{0x006E, 0x004E},
{0x006F, 0x004F},
{0x0070, 0x0050},
{0x0071, 0x0051},
{0x0072, 0x0052},
{0x0073, 0x0053},
{0x0074, 0x0054},
{0x0075, 0x0055},
{0x0076, 0x0056},
{0x0077, 0x0057},
{0x0078, 0x0058},
{0x0079, 0x0059},
{0x007A, 0x005A},
{0x00B5, 0x039C},
{0x00E0, 0x00C0},
{0x00E1, 0x00C1},
{0x00E2, 0x00C2},
{0x00E3, 0x00C3},
{0x00E4, 0x00C4},
{0x00E5, 0x00C5},
{0x00E6, 0x00C6},
{0x00E7, 0x00C7},
{0x00E8, 0x00C8},
{0x00E9, 0x00C9},
{0x00EA, 0x00CA},
{0x00EB, 0x00CB},
{0x00EC, 0x00CC},
{0x00ED, 0x00CD},
{0x00EE, 0x00CE},
{0x00EF, 0x00CF},
{0x00F0, 0x00D0},
{0x00F1, 0x00D1},
{0x00F2, 0x00D2},
{0x00F3, 0x00D3},
{0x00F4, 0x00D4},
{0x00F5, 0x00D5},
{0x00F6, 0x00D6},
{0x00F8, 0x00D8},
{0x00F9, 0x00D9},
{0x00FA, 0x00DA},
{0x00FB, 0x00DB},
{0x00FC, 0x00DC},
{0x00FD, 0x00DD},
{0x00FE, 0x00DE},
{0x00FF, 0x0178},
{0x0101, 0x0100},
{0x0103, 0x0102},
{0x0105, 0x0104},
{0x0107, 0x0106},
{0x0109, 0x0108},
{0x010B, 0x010A},
{0x010D, 0x010C},
{0x010F, 0x010E},
{0x0111, 0x0110},
{0x0113, 0x0112},
{0x0115, 0x0114},
{0x0117, 0x0116},
{0x0119, 0x0118},
{0x011B, 0x011A},
{0x011D, 0x011C},
{0x011F, 0x011E},
{0x0121, 0x0120},
{0x0123, 0x0122},
{0x0125, 0x0124},
{0x0127, 0x0126},
{0x0129, 0x0128},
{0x012B, 0x012A},
{0x012D, 0x012C},
{0x012F, 0x012E},
{0x0131, 0x0049},
{0x0133, 0x0132},
{0x0135, 0x0134},
{0x0137, 0x0136},
{0x013A, 0x0139},
{0x013C, 0x013B},
{0x013E, 0x013D},
{0x0140, 0x013F},
{0x0142, 0x0141},
{0x0144, 0x0143},
{0x0146, 0x0145},
{0x0148, 0x0147},
{0x014B, 0x014A},
{0x014D, 0x014C},
{0x014F, 0x014E},
{0x0151, 0x0150},
{0x0153, 0x0152},
{0x0155, 0x0154},
{0x0157, 0x0156},
{0x0159, 0x0158},
{0x015B, 0x015A},
{0x015D, 0x015C},
{0x015F, 0x015E},
{0x0161, 0x0160},
{0x0163, 0x0162},
{0x0165, 0x0164},
{0x0167, 0x0166},
{0x0169, 0x0168},
{0x016B, 0x016A},
{0x016D, 0x016C},
{0x016F, 0x016E},
{0x0171, 0x0170},
{0x0173, 0x0172},
{0x0175, 0x0174},
{0x0177, 0x0176},
{0x017A, 0x0179},
{0x017C, 0x017B},
{0x017E, 0x017D},
{0x017F, 0x0053},
{0x0180, 0x0243},
{0x0183, 0x0182},
{0x0185, 0x0184},
{0x0188, 0x0187},
{0x018C, 0x018B},
{0x0192, 0x0191},
{0x0195, 0x01F6},
{0x0199, 0x0198},
{0x019A, 0x023D},
{0x019B, 0xA7DC},
{0x019E, 0x0220},
{0x01A1, 0x01A0},
{0x01A3, 0x01A2},
{0x01A5, 0x01A4},
{0x01A8, 0x01A7},
{0x01AD, 0x01AC},
{0x01B0, 0x01AF},
{0x01B4, 0x01B3},
{0x01B6, 0x01B5},
{0x01B9, 0x01B8},
{0x01BD, 0x01BC},
{0x01BF, 0x01F7},
{0x01C5, 0x01C4},
{0x01C6, 0x01C4},
{0x01C8, 0x01C7},
{0x01C9, 0x01C7},
{0x01CB, 0x01CA},
{0x01CC, 0x01CA},
{0x01CE, 0x01CD},
{0x01D0, 0x01CF},
{0x01D2, 0x01D1},
{0x01D4, 0x01D3},
{0x01D6, 0x01D5},
{0x01D8, 0x01D7},
{0x01DA, 0x01D9},
{0x01DC, 0x01DB},
{0x01DD, 0x018E},
{0x01DF, 0x01DE},
{0x01E1, 0x01E0},
{0x01E3, 0x01E2},
{0x01E5, 0x01E4},
{0x01E7, 0x01E6},
{0x01E9, 0x01E8},
{0x01EB, 0x01EA},
{0x01ED, 0x01EC},
{0x01EF, 0x01EE},
{0x01F2, 0x01F1},
{0x01F3, 0x01F1},
{0x01F5, 0x01F4},
{0x01F9, 0x01F8},
{0x01FB, 0x01FA},
{0x01FD, 0x01FC},
{0x01FF, 0x01FE},
{0x0201, 0x0200},
{0x0203, 0x0202},
{0x0205, 0x0204},
{0x0207, 0x0206},
{0x0209, 0x0208},
{0x020B, 0x020A},
{0x020D, 0x020C},
{0x020F, 0x020E},
{0x0211, 0x0210},
{0x0213, 0x0212},
{0x0215, 0x0214},
{0x0217, 0x0216},
{0x0219, 0x0218},
{0x021B, 0x021A},
{0x021D, 0x021C},
{0x021F, 0x021E},
{0x0223, 0x0222},
{0x0225, 0x0224},
{0x0227, 0x0226},
{0x0229, 0x0228},
{0x022B, 0x022A},
{0x022D, 0x022C},
{0x022F, 0x022E},
{0x0231, 0x0230},
{0x0233, 0x0232},
{0x023C, 0x023B},
{0x023F, 0x2C7E},
{0x0240, 0x2C7F},
{0x0242, 0x0241},
{0x0247, 0x0246},
{0x0249, 0x0248},
{0x024B, 0x024A},
{0x024D, 0x024C},
{0x024F, 0x024E},
{0x0250, 0x2C6F},
{0x0251, 0x2C6D},
{0x0252, 0x2C70},
{0x0253, 0x0181},
{0x0254, 0x0186},
{0x0256, 0x0189},
{0x0257, 0x018A},
{0x0259, 0x018F},
{0x025B, 0x0190},
{0x025C, 0xA7AB},
{0x0260, 0x0193},
{0x0261, 0xA7AC},
{0x0263, 0x0194},
{0x0264, 0xA7CB},
{0x0265, 0xA78D},
{0x0266, 0xA7AA},
{0x0268, 0x0197},
{0x0269, 0x0196},
{0x026A, 0xA7AE},
{0x026B, 0x2C62},
{0x026C, 0xA7AD},
{0x026F, 0x019C},
{0x0271, 0x2C6E},
{0x0272, 0x019D},
{0x0275, 0x019F},
{0x027D, 0x2C64},
{0x0280, 0x01A6},
{0x0282, 0xA7C5},
{0x0283, 0x01A9},
{0x0287, 0xA7B1},
{0x0288, 0x01AE},
{0x0289, 0x0244},
{0x028A, 0x01B1},
{0x028B, 0x01B2},
{0x028C, 0x0245},
{0x0292, 0x01B7},
{0x029D, 0xA7B2},
{0x029E, 0xA7B0},
{0x0345, 0x0399},
{0x0371, 0x0370},
{0x0373, 0x0372},
{0x0377, 0x0376},
{0x037B, 0x03FD},
{0x037C, 0x03FE},
{0x037D, 0x03FF},
{0x03AC, 0x0386},
{0x03AD, 0x0388},
{0x03AE, 0x0389},
{0x03AF, 0x038A},
{0x03B1, 0x0391},
{0x03B2, 0x0392},
{0x03B3, 0x0393},
{0x03B4, 0x0394},
{0x03B5, 0x0395},
{0x03B6, 0x0396},
{0x03B7, 0x0397},
{0x03B8, 0x0398},
{0x03B9, 0x0399},
{0x03BA, 0x039A},
{0x03BB, 0x039B},
{0x03BC, 0x039C},
{0x03BD, 0x039D},
{0x03BE, 0x039E},
{0x03BF, 0x039F},
{0x03C0, 0x03A0},
{0x03C1, 0x03A1},
{0x03C2, 0x03A3},
{0x03C3, 0x03A3},
{0x03C4, 0x03A4},
{0x03C5, 0x03A5},
{0x03C6, 0x03A6},
{0x03C7, 0x03A7},
{0x03C8, 0x03A8},
{0x03C9, 0x03A9},
{0x03CA, 0x03AA},
{0x03CB, 0x03AB},
{0x03CC, 0x038C},
{0x03CD, 0x038E},
{0x03CE, 0x038F},
{0x03D0, 0x0392},
{0x03D1, 0x0398},
{0x03D5, 0x03A6},
{0x03D6, 0x03A0},
{0x03D7, 0x03CF},
{0x03D9, 0x03D8},
{0x03DB, 0x03DA},
{0x03DD, 0x03DC},
{0x03DF, 0x03DE},
{0x03E1, 0x03E0},
{0x03E3, 0x03E2},
{0x03E5, 0x03E4},
{0x03E7, 0x03E6},
{0x03E9, 0x03E8},
{0x03EB, 0x03EA},
{0x03ED, 0x03EC},
{0x03EF, 0x03EE},
{0x03F0, 0x039A},
{0x03F1, 0x03A1},
{0x03F2, 0x03F9},
{0x03F3, 0x037F},
{0x03F5, 0x0395},
{0x03F8, 0x03F7},
{0x03FB, 0x03FA},
{0x0430, 0x0410},
{0x0431, 0x0411},
{0x0432, 0x0412},
{0x0433, 0x0413},
{0x0434, 0x0414},
{0x0435, 0x0415},
{0x0436, 0x0416},
{0x0437, 0x0417},
{0x0438, 0x0418},
{0x0439, 0x0419},
{0x043A, 0x041A},
{0x043B, 0x041B},
{0x043C, 0x041C},
{0x043D, 0x041D},
{0x043E, 0x041E},
{0x043F, 0x041F},
{0x0440, 0x0420},
{0x0441, 0x0421},
{0x0442, 0x0422},
{0x0443, 0x0423},
{0x0444, 0x0424},
{0x0445, 0x0425},
{0x0446, 0x0426},
{0x0447, 0x0427},
{0x0448, 0x0428},
{0x0449, 0x0429},
{0x044A, 0x042A},
{0x044B, 0x042B},
{0x044C, 0x042C},
{0x044D, 0x042D},
{0x044E, 0x042E},
{0x044F, 0x042F},
{0x0450, 0x0400},
{0x0451, 0x0401},
{0x0452, 0x0402},
{0x0453, 0x0403},
{0x0454, 0x0404},
{0x0455, 0x0405},
{0x0456, 0x0406},
{0x0457, 0x0407},
{0x0458, 0x0408},
{0x0459, 0x0409},
{0x045A, 0x040A},
{0x045B, 0x040B},
{0x045C, 0x040C},
{0x045D, 0x040D},
{0x045E, 0x040E},
{0x045F, 0x040F},
{0x0461, 0x0460},
{0x0463, 0x0462},
{0x0465, 0x0464},
{0x0467, 0x0466},
{0x0469, 0x0468},
{0x046B, 0x046A},
{0x046D, 0x046C},
{0x046F, 0x046E},
{0x0471, 0x0470},
{0x0473, 0x0472},
{0x0475, 0x0474},
{0x0477, 0x0476},
{0x0479, 0x0478},
{0x047B, 0x047A},
{0x047D, 0x047C},
{0x047F, 0x047E},
{0x0481, 0x0480},
{0x048B, 0x048A},
{0x048D, 0x048C},
{0x048F, 0x048E},
{0x0491, 0x0490},
{0x0493, 0x0492},
{0x0495, 0x0494},
{0x0497, 0x0496},
{0x0499, 0x0498},
{0x049B, 0x049A},
{0x049D, 0x049C},
{0x049F, 0x049E},
{0x04A1, 0x04A0},
{0x04A3, 0x04A2},
{0x04A5, 0x04A4},
{0x04A7, 0x04A6},
{0x04A9, 0x04A8},
{0x04AB, 0x04AA},
{0x04AD, 0x04AC},
{0x04AF, 0x04AE},
{0x04B1, 0x04B0},
{0x04B3, 0x04B2},
{0x04B5, 0x04B4},
{0x04B7, 0x04B6},
{0x04B9, 0x04B8},
{0x04BB, 0x04BA},
{0x04BD, 0x04BC},
{0x04BF, 0x04BE},
{0x04C2, 0x04C1},
{0x04C4, 0x04C3},
{0x04C6, 0x04C5},
{0x04C8, 0x04C7},
{0x04CA, 0x04C9},
{0x04CC, 0x04CB},
{0x04CE, 0x04CD},
{0x04CF, 0x04C0},
{0x04D1, 0x04D0},
{0x04D3, 0x04D2},
{0x04D5, 0x04D4},
{0x04D7, 0x04D6},
{0x04D9, 0x04D8},
{0x04DB, 0x04DA},
{0x04DD, 0x04DC},
{0x04DF, 0x04DE},
{0x04E1, 0x04E0},
{0x04E3, 0x04E2},
{0x04E5, 0x04E4},
{0x04E7, 0x04E6},
{0x04E9, 0x04E8},
{0x04EB, 0x04EA},
{0x04ED, 0x04EC},
{0x04EF, 0x04EE},
{0x04F1, 0x04F0},
{0x04F3, 0x04F2},
{0x04F5, 0x04F4},
{0x04F7, 0x04F6},
{0x04F9, 0x04F8},
{0x04FB, 0x04FA},
{0x04FD, 0x04FC},
{0x04FF, 0x04FE},
{0x0501, 0x0500},
{0x0503, 0x0502},
{0x0505, 0x0504},
{0x0507, 0x0506},
{0x0509, 0x0508},
{0x050B, 0x050A},
{0x050D, 0x050C},
{0x050F, 0x050E},
{0x0511, 0x0510},
{0x0513, 0x0512},
{0x0515, 0x0514},
{0x0517, 0x0516},
{0x0519, 0x0518},
{0x051B, 0x051A},
{0x051D, 0x051C},
{0x051F, 0x051E},
{0x0521, 0x0520},
{0x0523, 0x0522},
{0x0525, 0x0524},
{0x0527, 0x0526},
{0x0529, 0x0528},
{0x052B, 0x052A},
{0x052D, 0x052C},
{0x052F, 0x052E},
{0x0561, 0x0531},
{0x0562, 0x0532},
{0x0563, 0x0533},
{0x0564, 0x0534},
{0x0565, 0x0535},
{0x0566, 0x0536},
{0x0567, 0x0537},
{0x0568, 0x0538},
{0x0569, 0x0539},
{0x056A, 0x053A},
{0x056B, 0x053B},
{0x056C, 0x053C},
{0x056D, 0x053D},
{0x056E, 0x053E},
{0x056F, 0x053F},
{0x0570, 0x0540},
{0x0571, 0x0541},
{0x0572, 0x0542},
{0x0573, 0x0543},
{0x0574, 0x0544},
{0x0575, 0x0545},
{0x0576, 0x0546},
{0x0577, 0x0547},
{0x0578, 0x0548},
{0x0579, 0x0549},
{0x057A, 0x054A},
{0x057B, 0x054B},
{0x057C, 0x054C},
{0x057D, 0x054D},
{0x057E, 0x054E},
{0x057F, 0x054F},
{0x0580, 0x0550},
{0x0581, 0x0551},
{0x0582, 0x0552},
{0x0583, 0x0553},
{0x0584, 0x0554},
{0x0585, 0x0555},
{0x0586, 0x0556},
{0x10D0, 0x1C90},
{0x10D1, 0x1C91},
{0x10D2, 0x1C92},
{0x10D3, 0x1C93},
{0x10D4, 0x1C94},
{0x10D5, 0x1C95},
{0x10D6, 0x1C96},
{0x10D7, 0x1C97},
{0x10D8, 0x1C98},
{0x10D9, 0x1C99},
{0x10DA, 0x1C9A},
{0x10DB, 0x1C9B},
{0x10DC, 0x1C9C},
{0x10DD, 0x1C9D},
{0x10DE, 0x1C9E},
{0x10DF, 0x1C9F},
{0x10E0, 0x1CA0},
{0x10E1, 0x1CA1},
{0x10E2, 0x1CA2},
{0x10E3, 0x1CA3},
{0x10E4, 0x1CA4},
{0x10E5, 0x1CA5},
{0x10E6, 0x1CA6},
{0x10E7, 0x1CA7},
{0x10E8, 0x1CA8},
{0x10E9, 0x1CA9},
{0x10EA, 0x1CAA},
{0x10EB, 0x1CAB},
{0x10EC, 0x1CAC},
{0x10ED, 0x1CAD},
{0x10EE, 0x1CAE},
{0x10EF, 0x1CAF},
{0x10F0, 0x1CB0},
{0x10F1, 0x1CB1},
{0x10F2, 0x1CB2},
{0x10F3, 0x1CB3},
{0x10F4, 0x1CB4},
{0x10F5, 0x1CB5},
{0x10F6, 0x1CB6},
{0x10F7, 0x1CB7},
{0x10F8, 0x1CB8},
{0x10F9, 0x1CB9},
{0x10FA, 0x1CBA},
{0x10FD, 0x1CBD},
{0x10FE, 0x1CBE},
{0x10FF, 0x1CBF},
{0x13F8, 0x13F0},
{0x13F9, 0x13F1},
{0x13FA, 0x13F2},
{0x13FB, 0x13F3},
{0x13FC, 0x13F4},
{0x13FD, 0x13F5},
{0x1C80, 0x0412},
{0x1C81, 0x0414},
{0x1C82, 0x041E},
{0x1C83, 0x0421},
{0x1C84, 0x0422},
{0x1C85, 0x0422},
{0x1C86, 0x042A},
{0x1C87, 0x0462},
{0x1C88, 0xA64A},
{0x1C8A, 0x1C89},
{0x1D79, 0xA77D},
{0x1D7D, 0x2C63},
{0x1D8E, 0xA7C6},
{0x1E01, 0x1E00},
{0x1E03, 0x1E02},
{0x1E05, 0x1E04},
{0x1E07, 0x1E06},
{0x1E09, 0x1E08},
{0x1E0B, 0x1E0A},
{0x1E0D, 0x1E0C},
{0x1E0F, 0x1E0E},
{0x1E11, 0x1E10},
{0x1E13, 0x1E12},
{0x1E15, 0x1E14},
{0x1E17, 0x1E16},
{0x1E19, 0x1E18},
{0x1E1B, 0x1E1A},
{0x1E1D, 0x1E1C},
{0x1E1F, 0x1E1E},
{0x1E21, 0x1E20},
{0x1E23, 0x1E22},
{0x1E25, 0x1E24},
{0x1E27, 0x1E26},
{0x1E29, 0x1E28},
{0x1E2B, 0x1E2A},
{0x1E2D, 0x1E2C},
{0x1E2F, 0x1E2E},
{0x1E31, 0x1E30},
{0x1E33, 0x1E32},
{0x1E35, 0x1E34},
{0x1E37, 0x1E36},
{0x1E39, 0x1E38},
{0x1E3B, 0x1E3A},
{0x1E3D, 0x1E3C},
{0x1E3F, 0x1E3E},
{0x1E41, 0x1E40},
{0x1E43, 0x1E42},
{0x1E45, 0x1E44},
{0x1E47, 0x1E46},
{0x1E49, 0x1E48},
{0x1E4B, 0x1E4A},
{0x1E4D, 0x1E4C},
{0x1E4F, 0x1E4E},
{0x1E51, 0x1E50},
{0x1E53, 0x1E52},
{0x1E55, 0x1E54},
{0x1E57, 0x1E56},
{0x1E59, 0x1E58},
{0x1E5B, 0x1E5A},
{0x1E5D, 0x1E5C},
{0x1E5F, 0x1E5E},
{0x1E61, 0x1E60},
{0x1E63, 0x1E62},
{0x1E65, 0x1E64},
{0x1E67, 0x1E66},
{0x1E69, 0x1E68},
{0x1E6B, 0x1E6A},
{0x1E6D, 0x1E6C},
{0x1E6F, 0x1E6E},
{0x1E71, 0x1E70},
{0x1E73, 0x1E72},
{0x1E75, 0x1E74},
{0x1E77, 0x1E76},
{0x1E79, 0x1E78},
{0x1E7B, 0x1E7A},
{0x1E7D, 0x1E7C},
{0x1E7F, 0x1E7E},
{0x1E81, 0x1E80},
{0x1E83, 0x1E82},
{0x1E85, 0x1E84},
{0x1E87, 0x1E86},
{0x1E89, 0x1E88},
{0x1E8B, 0x1E8A},
{0x1E8D, 0x1E8C},
{0x1E8F, 0x1E8E},
{0x1E91, 0x1E90},
{0x1E93, 0x1E92},
{0x1E95, 0x1E94},
{0x1E9B, 0x1E60},
{0x1EA1, 0x1EA0},
{0x1EA3, 0x1EA2},
{0x1EA5, 0x1EA4},
{0x1EA7, 0x1EA6},
{0x1EA9, 0x1EA8},
{0x1EAB, 0x1EAA},
{0x1EAD, 0x1EAC},
{0x1EAF, 0x1EAE},
{0x1EB1, 0x1EB0},
{0x1EB3, 0x1EB2},
{0x1EB5, 0x1EB4},
{0x1EB7, 0x1EB6},
{0x1EB9, 0x1EB8},
{0x1EBB, 0x1EBA},
{0x1EBD, 0x1EBC},
{0x1EBF, 0x1EBE},
{0x1EC1, 0x1EC0},
{0x1EC3, 0x1EC2},
{0x1EC5, 0x1EC4},
{0x1EC7, 0x1EC6},
{0x1EC9, 0x1EC8},
{0x1ECB, 0x1ECA},
{0x1ECD, 0x1ECC},
{0x1ECF, 0x1ECE},
{0x1ED1, 0x1ED0},
{0x1ED3, 0x1ED2},
{0x1ED5, 0x1ED4},
{0x1ED7, 0x1ED6},
{0x1ED9, 0x1ED8},
{0x1EDB, 0x1EDA},
{0x1EDD, 0x1EDC},
{0x1EDF, 0x1EDE},
{0x1EE1, 0x1EE0},
{0x1EE3, 0x1EE2},
{0x1EE5, 0x1EE4},
{0x1EE7, 0x1EE6},
{0x1EE9, 0x1EE8},
{0x1EEB, 0x1EEA},
{0x1EED, 0x1EEC},
{0x1EEF, 0x1EEE},
{0x1EF1, 0x1EF0},
{0x1EF3, 0x1EF2},
{0x1EF5, 0x1EF4},
{0x1EF7, 0x1EF6},
{0x1EF9, 0x1EF8},
{0x1EFB, 0x1EFA},
{0x1EFD, 0x1EFC},
{0x1EFF, 0x1EFE},
{0x1F00, 0x1F08},
{0x1F01, 0x1F09},
{0x1F02, 0x1F0A},
{0x1F03, 0x1F0B},
{0x1F04, 0x1F0C},
{0x1F05, 0x1F0D},
{0x1F06, 0x1F0E},
{0x1F07, 0x1F0F},
{0x1F10, 0x1F18},
{0x1F11, 0x1F19},
{0x1F12, 0x1F1A},
{0x1F13, 0x1F1B},
{0x1F14, 0x1F1C},
{0x1F15, 0x1F1D},
{0x1F20, 0x1F28},
{0x1F21, 0x1F29},
{0x1F22, 0x1F2A},
{0x1F23, 0x1F2B},
{0x1F24, 0x1F2C},
{0x1F25, 0x1F2D},
{0x1F26, 0x1F2E},
{0x1F27, 0x1F2F},
{0x1F30, 0x1F38},
{0x1F31, 0x1F39},
{0x1F32, 0x1F3A},
{0x1F33, 0x1F3B},
{0x1F34, 0x1F3C},
{0x1F35, 0x1F3D},
{0x1F36, 0x1F3E},
{0x1F37, 0x1F3F},
{0x1F40, 0x1F48},
{0x1F41, 0x1F49},
{0x1F42, 0x1F4A},
{0x1F43, 0x1F4B},
{0x1F44, 0x1F4C},
{0x1F45, 0x1F4D},
{0x1F51, 0x1F59},
{0x1F53, 0x1F5B},
{0x1F55, 0x1F5D},
{0x1F57, 0x1F5F},
{0x1F60, 0x1F68},
{0x1F61, 0x1F69},
{0x1F62, 0x1F6A},
{0x1F63, 0x1F6B},
{0x1F64, 0x1F6C},
{0x1F65, 0x1F6D},
{0x1F66, 0x1F6E},
{0x1F67, 0x1F6F},
{0x1F70, 0x1FBA},
{0x1F71, 0x1FBB},
{0x1F72, 0x1FC8},
{0x1F73, 0x1FC9},
{0x1F74, 0x1FCA},
{0x1F75, 0x1FCB},
{0x1F76, 0x1FDA},
{0x1F77, 0x1FDB},
{0x1F78, 0x1FF8},
{0x1F79, 0x1FF9},
{0x1F7A, 0x1FEA},
{0x1F7B, 0x1FEB},
{0x1F7C, 0x1FFA},
{0x1F7D, 0x1FFB},
{0x1F80, 0x1F88},
{0x1F81, 0x1F89},
{0x1F82, 0x1F8A},
{0x1F83, 0x1F8B},
{0x1F84, 0x1F8C},
{0x1F85, 0x1F8D},
{0x1F86, 0x1F8E},
{0x1F87, 0x1F8F},
{0x1F90, 0x1F98},
{0x1F91, 0x1F99},
{0x1F92, 0x1F9A},
{0x1F93, 0x1F9B},
{0x1F94, 0x1F9C},
{0x1F95, 0x1F9D},
{0x1F96, 0x1F9E},
{0x1F97, 0x1F9F},
{0x1FA0, 0x1FA8},
{0x1FA1, 0x1FA9},
{0x1FA2, 0x1FAA},
{0x1FA3, 0x1FAB},
{0x1FA4, 0x1FAC},
{0x1FA5, 0x1FAD},
{0x1FA6, 0x1FAE},
{0x1FA7, 0x1FAF},
{0x1FB0, 0x1FB8},
{0x1FB1, 0x1FB9},
{0x1FB3, 0x1FBC},
{0x1FBE, 0x0399},
{0x1FC3, 0x1FCC},
{0x1FD0, 0x1FD8},
{0x1FD1, 0x1FD9},
{0x1FE0, 0x1FE8},
{0x1FE1, 0x1FE9},
{0x1FE5, 0x1FEC},
{0x1FF3, 0x1FFC},
{0x214E, 0x2132},
{0x2170, 0x2160},
{0x2171, 0x2161},
{0x2172, 0x2162},
{0x2173, 0x2163},
{0x2174, 0x2164},
{0x2175, 0x2165},
{0x2176, 0x2166},
{0x2177, 0x2167},
{0x2178, 0x2168},
{0x2179, 0x2169},
{0x217A, 0x216A},
{0x217B, 0x216B},
{0x217C, 0x216C},
{0x217D, 0x216D},
{0x217E, 0x216E},
{0x217F, 0x216F},
{0x2184, 0x2183},
{0x24D0, 0x24B6},
{0x24D1, 0x24B7},
{0x24D2, 0x24B8},
{0x24D3, 0x24B9},
{0x24D4, 0x24BA},
{0x24D5, 0x24BB},
{0x24D6, 0x24BC},
{0x24D7, 0x24BD},
{0x24D8, 0x24BE},
{0x24D9, 0x24BF},
{0x24DA, 0x24C0},
{0x24DB, 0x24C1},
{0x24DC, 0x24C2},
{0x24DD, 0x24C3},
{0x24DE, 0x24C4},
{0x24DF, 0x24C5},
{0x24E0, 0x24C6},
{0x24E1, 0x24C7},
{0x24E2, 0x24C8},
{0x24E3, 0x24C9},
{0x24E4, 0x24CA},
{0x24E5, 0x24CB},
{0x24E6, 0x24CC},
{0x24E7, 0x24CD},
{0x24E8, 0x24CE},
{0x24E9, 0x24CF},
{0x2C30, 0x2C00},
{0x2C31, 0x2C01},
{0x2C32, 0x2C02},
{0x2C33, 0x2C03},
{0x2C34, 0x2C04},
{0x2C35, 0x2C05},
{0x2C36, 0x2C06},
{0x2C37, 0x2C07},
{0x2C38, 0x2C08},
{0x2C39, 0x2C09},
{0x2C3A, 0x2C0A},
{0x2C3B, 0x2C0B},
{0x2C3C, 0x2C0C},
{0x2C3D, 0x2C0D},
{0x2C3E, 0x2C0E},
{0x2C3F, 0x2C0F},
{0x2C40, 0x2C10},
{0x2C41, 0x2C11},
{0x2C42, 0x2C12},
{0x2C43, 0x2C13},
{0x2C44, 0x2C14},
{0x2C45, 0x2C15},
{0x2C46, 0x2C16},
{0x2C47, 0x2C17},
{0x2C48, 0x2C18},
{0x2C49, 0x2C19},
{0x2C4A, 0x2C1A},
{0x2C4B, 0x2C1B},
{0x2C4C, 0x2C1C},
{0x2C4D, 0x2C1D},
{0x2C4E, 0x2C1E},
{0x2C4F, 0x2C1F},
{0x2C50, 0x2C20},
{0x2C51, 0x2C21},
{0x2C52, 0x2C22},
{0x2C53, 0x2C23},
{0x2C54, 0x2C24},
{0x2C55, 0x2C25},
{0x2C56, 0x2C26},
{0x2C57, 0x2C27},
{0x2C58, 0x2C28},
{0x2C59, 0x2C29},
{0x2C5A, 0x2C2A},
{0x2C5B, 0x2C2B},
{0x2C5C, 0x2C2C},
{0x2C5D, 0x2C2D},
{0x2C5E, 0x2C2E},
{0x2C5F, 0x2C2F},
{0x2C61, 0x2C60},
{0x2C65, 0x023A},
{0x2C66, 0x023E},
{0x2C68, 0x2C67},
{0x2C6A, 0x2C69},
{0x2C6C, 0x2C6B},
{0x2C73, 0x2C72},
{0x2C76, 0x2C75},
{0x2C81, 0x2C80},
{0x2C83, 0x2C82},
{0x2C85, 0x2C84},
{0x2C87, 0x2C86},
{0x2C89, 0x2C88},
{0x2C8B, 0x2C8A},
{0x2C8D, 0x2C8C},
{0x2C8F, 0x2C8E},
{0x2C91, 0x2C90},
{0x2C93, 0x2C92},
{0x2C95, 0x2C94},
{0x2C97, 0x2C96},
{0x2C99, 0x2C98},
{0x2C9B, 0x2C9A},
{0x2C9D, 0x2C9C},
{0x2C9F, 0x2C9E},
{0x2CA1, 0x2CA0},
{0x2CA3, 0x2CA2},
{0x2CA5, 0x2CA4},
{0x2CA7, 0x2CA6},
{0x2CA9, 0x2CA8},
{0x2CAB, 0x2CAA},
{0x2CAD, 0x2CAC},
{0x2CAF, 0x2CAE},
{0x2CB1, 0x2CB0},
{0x2CB3, 0x2CB2},
{0x2CB5, 0x2CB4},
{0x2CB7, 0x2CB6},
{0x2CB9, 0x2CB8},
{0x2CBB, 0x2CBA},
{0x2CBD, 0x2CBC},
{0x2CBF, 0x2CBE},
{0x2CC1, 0x2CC0},
{0x2CC3, 0x2CC2},
{0x2CC5, 0x2CC4},
{0x2CC7, 0x2CC6},
{0x2CC9, 0x2CC8},
{0x2CCB, 0x2CCA},
{0x2CCD, 0x2CCC},
{0x2CCF, 0x2CCE},
{0x2CD1, 0x2CD0},
{0x2CD3, 0x2CD2},
{0x2CD5, 0x2CD4},
{0x2CD7, 0x2CD6},
{0x2CD9, 0x2CD8},
{0x2CDB, 0x2CDA},
{0x2CDD, 0x2CDC},
{0x2CDF, 0x2CDE},
{0x2CE1, 0x2CE0},
{0x2CE3, 0x2CE2},
{0x2CEC, 0x2CEB},
{0x2CEE, 0x2CED},
{0x2CF3, 0x2CF2},
{0x2D00, 0x10A0},
{0x2D01, 0x10A1},
{0x2D02, 0x10A2},
{0x2D03, 0x10A3},
{0x2D04, 0x10A4},
{0x2D05, 0x10A5},
{0x2D06, 0x10A6},
{0x2D07, 0x10A7},
{0x2D08, 0x10A8},
{0x2D09, 0x10A9},
{0x2D0A, 0x10AA},
{0x2D0B, 0x10AB},
{0x2D0C, 0x10AC},
{0x2D0D, 0x10AD},
{0x2D0E, 0x10AE},
{0x2D0F, 0x10AF},
{0x2D10, 0x10B0},
{0x2D11, 0x10B1},
{0x2D12, 0x10B2},
{0x2D13, 0x10B3},
{0x2D14, 0x10B4},
{0x2D15, 0x10B5},
{0x2D16, 0x10B6},
{0x2D17, 0x10B7},
{0x2D18, 0x10B8},
{0x2D19, 0x10B9},
{0x2D1A, 0x10BA},
{0x2D1B, 0x10BB},
{0x2D1C, 0x10BC},
{0x2D1D, 0x10BD},
{0x2D1E, 0x10BE},
{0x2D1F, 0x10BF},
{0x2D20, 0x10C0},
{0x2D21, 0x10C1},
{0x2D22, 0x10C2},
{0x2D23, 0x10C3},
{0x2D24, 0x10C4},
{0x2D25, 0x10C5},
{0x2D27, 0x10C7},
{0x2D2D, 0x10CD},
{0xA641, 0xA640},
{0xA643, 0xA642},
{0xA645, 0xA644},
{0xA647, 0xA646},
{0xA649, 0xA648},
{0xA64B, 0xA64A},
{0xA64D, 0xA64C},
{0xA64F, 0xA64E},
{0xA651, 0xA650},
{0xA653, 0xA652},
{0xA655, 0xA654},
{0xA657, 0xA656},
{0xA659, 0xA658},
{0xA65B, 0xA65A},
{0xA65D, 0xA65C},
{0xA65F, 0xA65E},
{0xA661, 0xA660},
{0xA663, 0xA662},
{0xA665, 0xA664},
{0xA667, 0xA666},
{0xA669, 0xA668},
{0xA66B, 0xA66A},
{0xA66D, 0xA66C},
{0xA681, 0xA680},
{0xA683, 0xA682},
{0xA685, 0xA684},
{0xA687, 0xA686},
{0xA689, 0xA688},
{0xA68B, 0xA68A},
{0xA68D, 0xA68C},
{0xA68F, 0xA68E},
{0xA691, 0xA690},
{0xA693, 0xA692},
{0xA695, 0xA694},
{0xA697, 0xA696},
{0xA699, 0xA698},
{0xA69B, 0xA69A},
{0xA723, 0xA722},
{0xA725, 0xA724},
{0xA727, 0xA726},
{0xA729, 0xA728},
{0xA72B, 0xA72A},
{0xA72D, 0xA72C},
{0xA72F, 0xA72E},
{0xA733, 0xA732},
{0xA735, 0xA734},
{0xA737, 0xA736},
{0xA739, 0xA738},
{0xA73B, 0xA73A},
{0xA73D, 0xA73C},
{0xA73F, 0xA73E},
{0xA741, 0xA740},
{0xA743, 0xA742},
{0xA745, 0xA744},
{0xA747, 0xA746},
{0xA749, 0xA748},
{0xA74B, 0xA74A},
{0xA74D, 0xA74C},
{0xA74F, 0xA74E},
{0xA751, 0xA750},
{0xA753, 0xA752},
{0xA755, 0xA754},
{0xA757, 0xA756},
{0xA759, 0xA758},
{0xA75B, 0xA75A},
{0xA75D, 0xA75C},
{0xA75F, 0xA75E},
{0xA761, 0xA760},
{0xA763, 0xA762},
{0xA765, 0xA764},
{0xA767, 0xA766},
{0xA769, 0xA768},
{0xA76B, 0xA76A},
{0xA76D, 0xA76C},
{0xA76F, 0xA76E},
{0xA77A, 0xA779},
{0xA77C, 0xA77B},
{0xA77F, 0xA77E},
{0xA781, 0xA780},
{0xA783, 0xA782},
{0xA785, 0xA784},
{0xA787, 0xA786},
{0xA78C, 0xA78B},
{0xA791, 0xA790},
{0xA793, 0xA792},
{0xA794, 0xA7C4},
{0xA797, 0xA796},
{0xA799, 0xA798},
{0xA79B, 0xA79A},
{0xA79D, 0xA79C},
{0xA79F, 0xA79E},
{0xA7A1, 0xA7A0},
{0xA7A3, 0xA7A2},
{0xA7A5, 0xA7A4},
{0xA7A7, 0xA7A6},
{0xA7A9, 0xA7A8},
{0xA7B5, 0xA7B4},
{0xA7B7, 0xA7B6},
{0xA7B9, 0xA7B8},
{0xA7BB, 0xA7BA},
{0xA7BD, 0xA7BC},
{0xA7BF, 0xA7BE},
{0xA7C1, 0xA7C0},
{0xA7C3, 0xA7C2},
{0xA7C8, 0xA7C7},
{0xA7CA, 0xA7C9},
{0xA7CD, 0xA7CC},
{0xA7D1, 0xA7D0},
{0xA7D7, 0xA7D6},
{0xA7D9, 0xA7D8},
{0xA7DB, 0xA7DA},
{0xA7F6, 0xA7F5},
{0xAB53, 0xA7B3},
{0xAB70, 0x13A0},
{0xAB71, 0x13A1},
{0xAB72, 0x13A2},
{0xAB73, 0x13A3},
{0xAB74, 0x13A4},
{0xAB75, 0x13A5},
{0xAB76, 0x13A6},
{0xAB77, 0x13A7},
{0xAB78, 0x13A8},
{0xAB79, 0x13A9},
{0xAB7A, 0x13AA},
{0xAB7B, 0x13AB},
{0xAB7C, 0x13AC},
{0xAB7D, 0x13AD},
{0xAB7E, 0x13AE},
{0xAB7F, 0x13AF},
{0xAB80, 0x13B0},
{0xAB81, 0x13B1},
{0xAB82, 0x13B2},
{0xAB83, 0x13B3},
{0xAB84, 0x13B4},
{0xAB85, 0x13B5},
{0xAB86, 0x13B6},
{0xAB87, 0x13B7},
{0xAB88, 0x13B8},
{0xAB89, 0x13B9},
{0xAB8A, 0x13BA},
{0xAB8B, 0x13BB},
{0xAB8C, 0x13BC},
{0xAB8D, 0x13BD},
{0xAB8E, 0x13BE},
{0xAB8F, 0x13BF},
{0xAB90, 0x13C0},
{0xAB91, 0x13C1},
{0xAB92, 0x13C2},
{0xAB93, 0x13C3},
{0xAB94, 0x13C4},
{0xAB95, 0x13C5},
{0xAB96, 0x13C6},
{0xAB97, 0x13C7},
{0xAB98, 0x13C8},
{0xAB99, 0x13C9},
{0xAB9A, 0x13CA},
{0xAB9B, 0x13CB},
{0xAB9C, 0x13CC},
{0xAB9D, 0x13CD},
{0xAB9E, 0x13CE},
{0xAB9F, 0x13CF},
{0xABA0, 0x13D0},
{0xABA1, 0x13D1},
{0xABA2, 0x13D2},
{0xABA3, 0x13D3},
{0xABA4, 0x13D4},
{0xABA5, 0x13D5},
{0xABA6, 0x13D6},
{0xABA7, 0x13D7},
{0xABA8, 0x13D8},
{0xABA9, 0x13D9},
{0xABAA, 0x13DA},
{0xABAB, 0x13DB},
{0xABAC, 0x13DC},
{0xABAD, 0x13DD},
{0xABAE, 0x13DE},
{0xABAF, 0x13DF},
{0xABB0, 0x13E0},
{0xABB1, 0x13E1},
{0xABB2, 0x13E2},
{0xABB3, 0x13E3},
{0xABB4, 0x13E4},
{0xABB5, 0x13E5},
{0xABB6, 0x13E6},
{0xABB7, 0x13E7},
{0xABB8, 0x13E8},
{0xABB9, 0x13E9},
{0xABBA, 0x13EA},
{0xABBB, 0x13EB},
{0xABBC, 0x13EC},
{0xABBD, 0x13ED},
{0xABBE, 0x13EE},
{0xABBF, 0x13EF},
{0xFF41, 0xFF21},
{0xFF42, 0xFF22},
{0xFF43, 0xFF23},
{0xFF44, 0xFF24},
{0xFF45, 0xFF25},
{0xFF46, 0xFF26},
{0xFF47, 0xFF27},
{0xFF48, 0xFF28},
{0xFF49, 0xFF29},
{0xFF4A, 0xFF2A},
{0xFF4B, 0xFF2B},
{0xFF4C, 0xFF2C},
{0xFF4D, 0xFF2D},
{0xFF4E, 0xFF2E},
{0xFF4F, 0xFF2F},
{0xFF50, 0xFF30},
{0xFF51, 0xFF31},
{0xFF52, 0xFF32},
{0xFF53, 0xFF33},
{0xFF54, 0xFF34},
{0xFF55, 0xFF35},
{0xFF56, 0xFF36},
{0xFF57, 0xFF37},
{0xFF58, 0xFF38},
{0xFF59, 0xFF39},
{0xFF5A, 0xFF3A},
{0x10428, 0x10400},
{0x10429, 0x10401},
{0x1042A, 0x10402},
{0x1042B, 0x10403},
{0x1042C, 0x10404},
{0x1042D, 0x10405},
{0x1042E, 0x10406},
{0x1042F, 0x10407},
{0x10430, 0x10408},
{0x10431, 0x10409},
{0x10432, 0x1040A},
{0x10433, 0x1040B},
{0x10434, 0x1040C},
{0x10435, 0x1040D},
{0x10436, 0x1040E},
{0x10437, 0x1040F},
{0x10438, 0x10410},
{0x10439, 0x10411},
{0x1043A, 0x10412},
{0x1043B, 0x10413},
{0x1043C, 0x10414},
{0x1043D, 0x10415},
{0x1043E, 0x10416},
{0x1043F, 0x10417},
{0x10440, 0x10418},
{0x10441, 0x10419},
{0x10442, 0x1041A},
{0x10443, 0x1041B},
{0x10444, 0x1041C},
{0x10445, 0x1041D},
{0x10446, 0x1041E},
{0x10447, 0x1041F},
{0x10448, 0x10420},
{0x10449, 0x10421},
{0x1044A, 0x10422},
{0x1044B, 0x10423},
{0x1044C, 0x10424},
{0x1044D, 0x10425},
{0x1044E, 0x10426},
{0x1044F, 0x10427},
{0x104D8, 0x104B0},
{0x104D9, 0x104B1},
{0x104DA, 0x104B2},
{0x104DB, 0x104B3},
{0x104DC, 0x104B4},
{0x104DD, 0x104B5},
{0x104DE, 0x104B6},
{0x104DF, 0x104B7},
{0x104E0, 0x104B8},
{0x104E1, 0x104B9},
{0x104E2, 0x104BA},
{0x104E3, 0x104BB},
{0x104E4, 0x104BC},
{0x104E5, 0x104BD},
{0x104E6, 0x104BE},
{0x104E7, 0x104BF},
{0x104E8, 0x104C0},
{0x104E9, 0x104C1},
{0x104EA, 0x104C2},
{0x104EB, 0x104C3},
{0x104EC, 0x104C4},
{0x104ED, 0x104C5},
{0x104EE, 0x104C6},
{0x104EF, 0x104C7},
{0x104F0, 0x104C8},
{0x104F1, 0x104C9},
{0x104F2, 0x104CA},
{0x104F3, 0x104CB},
{0x104F4, 0x104CC},
{0x104F5, 0x104CD},
{0x104F6, 0x104CE},
{0x104F7, 0x104CF},
{0x104F8, 0x104D0},
{0x104F9, 0x104D1},
{0x104FA, 0x104D2},
{0x104FB, 0x104D3},
{0x10597, 0x10570},
{0x10598, 0x10571},
{0x10599, 0x10572},
{0x1059A, 0x10573},
{0x1059B, 0x10574},
{0x1059C, 0x10575},
{0x1059D, 0x10576},
{0x1059E, 0x10577},
{0x1059F, 0x10578},
{0x105A0, 0x10579},
{0x105A1, 0x1057A},
{0x105A3, 0x1057C},
{0x105A4, 0x1057D},
{0x105A5, 0x1057E},
{0x105A6, 0x1057F},
{0x105A7, 0x10580},
{0x105A8, 0x10581},
{0x105A9, 0x10582},
{0x105AA, 0x10583},
{0x105AB, 0x10584},
{0x105AC, 0x10585},
{0x105AD, 0x10586},
{0x105AE, 0x10587},
{0x105AF, 0x10588},
{0x105B0, 0x10589},
{0x105B1, 0x1058A},
{0x105B3, 0x1058C},
{0x105B4, 0x1058D},
{0x105B5, 0x1058E},
{0x105B6, 0x1058F},
{0x105B7, 0x10590},
{0x105B8, 0x10591},
{0x105B9, 0x10592},
{0x105BB, 0x10594},
{0x105BC, 0x10595},
{0x10CC0, 0x10C80},
{0x10CC1, 0x10C81},
{0x10CC2, 0x10C82},
{0x10CC3, 0x10C83},
{0x10CC4, 0x10C84},
{0x10CC5, 0x10C85},
{0x10CC6, 0x10C86},
{0x10CC7, 0x10C87},
{0x10CC8, 0x10C88},
{0x10CC9, 0x10C89},
{0x10CCA, 0x10C8A},
{0x10CCB, 0x10C8B},
{0x10CCC, 0x10C8C},
{0x10CCD, 0x10C8D},
{0x10CCE, 0x10C8E},
{0x10CCF, 0x10C8F},
{0x10CD0, 0x10C90},
{0x10CD1, 0x10C91},
{0x10CD2, 0x10C92},
{0x10CD3, 0x10C93},
{0x10CD4, 0x10C94},
{0x10CD5, 0x10C95},
{0x10CD6, 0x10C96},
{0x10CD7, 0x10C97},
{0x10CD8, 0x10C98},
{0x10CD9, 0x10C99},
{0x10CDA, 0x10C9A},
{0x10CDB, 0x10C9B},
{0x10CDC, 0x10C9C},
{0x10CDD, 0x10C9D},
{0x10CDE, 0x10C9E},
{0x10CDF, 0x10C9F},
{0x10CE0, 0x10CA0},
{0x10CE1, 0x10CA1},
{0x10CE2, 0x10CA2},
{0x10CE3, 0x10CA3},
{0x10CE4, 0x10CA4},
{0x10CE5, 0x10CA5},
{0x10CE6, 0x10CA6},
{0x10CE7, 0x10CA7},
{0x10CE8, 0x10CA8},
{0x10CE9, 0x10CA9},
{0x10CEA, 0x10CAA},
{0x10CEB, 0x10CAB},
{0x10CEC, 0x10CAC},
{0x10CED, 0x10CAD},
{0x10CEE, 0x10CAE},
{0x10CEF, 0x10CAF},
{0x10CF0, 0x10CB0},
{0x10CF1, 0x10CB1},
{0x10CF2, 0x10CB2},
{0x10D70, 0x10D50},
{0x10D71, 0x10D51},
{0x10D72, 0x10D52},
{0x10D73, 0x10D53},
{0x10D74, 0x10D54},
{0x10D75, 0x10D55},
{0x10D76, 0x10D56},
{0x10D77, 0x10D57},
{0x10D78, 0x10D58},
{0x10D79, 0x10D59},
{0x10D7A, 0x10D5A},
{0x10D7B, 0x10D5B},
{0x10D7C, 0x10D5C},
{0x10D7D, 0x10D5D},
{0x10D7E, 0x10D5E},
{0x10D7F, 0x10D5F},
{0x10D80, 0x10D60},
{0x10D81, 0x10D61},
{0x10D82, 0x10D62},
{0x10D83, 0x10D63},
{0x10D84, 0x10D64},
{0x10D85, 0x10D65},
{0x118C0, 0x118A0},
{0x118C1, 0x118A1},
{0x118C2, 0x118A2},
{0x118C3, 0x118A3},
{0x118C4, 0x118A4},
{0x118C5, 0x118A5},
{0x118C6, 0x118A6},
{0x118C7, 0x118A7},
{0x118C8, 0x118A8},
{0x118C9, 0x118A9},
{0x118CA, 0x118AA},
{0x118CB, 0x118AB},
{0x118CC, 0x118AC},
{0x118CD, 0x118AD},
{0x118CE, 0x118AE},
{0x118CF, 0x118AF},
{0x118D0, 0x118B0},
{0x118D1, 0x118B1},
{0x118D2, 0x118B2},
{0x118D3, 0x118B3},
{0x118D4, 0x118B4},
{0x118D5, 0x118B5},
{0x118D6, 0x118B6},
{0x118D7, 0x118B7},
{0x118D8, 0x118B8},
{0x118D9, 0x118B9},
{0x118DA, 0x118BA},
{0x118DB, 0x118BB},
{0x118DC, 0x118BC},
{0x118DD, 0x118BD},
{0x118DE, 0x118BE},
{0x118DF, 0x118BF},
{0x16E60, 0x16E40},
{0x16E61, 0x16E41},
{0x16E62, 0x16E42},
{0x16E63, 0x16E43},
{0x16E64, 0x16E44},
{0x16E65, 0x16E45},
{0x16E66, 0x16E46},
{0x16E67, 0x16E47},
{0x16E68, 0x16E48},
{0x16E69, 0x16E49},
{0x16E6A, 0x16E4A},
{0x16E6B, 0x16E4B},
{0x16E6C, 0x16E4C},
{0x16E6D, 0x16E4D},
{0x16E6E, 0x16E4E},
{0x16E6F, 0x16E4F},
{0x16E70, 0x16E50},
{0x16E71, 0x16E51},
{0x16E72, 0x16E52},
{0x16E73, 0x16E53},
{0x16E74, 0x16E54},
{0x16E75, 0x16E55},
{0x16E76, 0x16E56},
{0x16E77, 0x16E57},
{0x16E78, 0x16E58},
{0x16E79, 0x16E59},
{0x16E7A, 0x16E5A},
{0x16E7B, 0x16E5B},
{0x16E7C, 0x16E5C},
{0x16E7D, 0x16E5D},
{0x16E7E, 0x16E5E},
{0x16E7F, 0x16E5F},
{0x1E922, 0x1E900},
{0x1E923, 0x1E901},
{0x1E924, 0x1E902},
{0x1E925, 0x1E903},
{0x1E926, 0x1E904},
{0x1E927, 0x1E905},
{0x1E928, 0x1E906},
{0x1E929, 0x1E907},
{0x1E92A, 0x1E908},
{0x1E92B, 0x1E909},
{0x1E92C, 0x1E90A},
{0x1E92D, 0x1E90B},
{0x1E92E, 0x1E90C},
{0x1E92F, 0x1E90D},
{0x1E930, 0x1E90E},
{0x1E931, 0x1E90F},
{0x1E932, 0x1E910},
{0x1E933, 0x1E911},
{0x1E934, 0x1E912},
{0x1E935, 0x1E913},
{0x1E936, 0x1E914},
{0x1E937, 0x1E915},
{0x1E938, 0x1E916},
{0x1E939, 0x1E917},
{0x1E93A, 0x1E918},
{0x1E93B, 0x1E919},
{0x1E93C, 0x1E91A},
{0x1E93D, 0x1E91B},
{0x1E93E, 0x1E91C},
{0x1E93F, 0x1E91D},
{0x1E940, 0x1E91E},
{0x1E941, 0x1E91F},
{0x1E942, 0x1E920},
{0x1E943, 0x1E921},
};

static const
struct UnicodeMapEntry g_unicode_lower[] = {
{0x0041, 0x0061},
{0x0042, 0x0062},
{0x0043, 0x0063},
{0x0044, 0x0064},
{0x0045, 0x0065},
{0x0046, 0x0066},
{0x0047, 0x0067},
{0x0048, 0x0068},
{0x0049, 0x0069},
{0x004A, 0x006A},
{0x004B, 0x006B},
{0x004C, 0x006C},
{0x004D, 0x006D},
{0x004E, 0x006E},
{0x004F, 0x006F},
{0x0050, 0x0070},
{0x0051, 0x0071},
{0x0052, 0x0072},
{0x0053, 0x0073},
{0x0054, 0x0074},
{0x0055, 0x0075},
{0x0056, 0x0076},
{0x0057, 0x0077},
{0x0058, 0x0078},
{0x0059, 0x0079},
{0x005A, 0x007A},
{0x00C0, 0x00E0},
{0x00C1, 0x00E1},
{0x00C2, 0x00E2},
{0x00C3, 0x00E3},
{0x00C4, 0x00E4},
{0x00C5, 0x00E5},
{0x00C6, 0x00E6},
{0x00C7, 0x00E7},
{0x00C8, 0x00E8},
{0x00C9, 0x00E9},
{0x00CA, 0x00EA},
{0x00CB, 0x00EB},
{0x00CC, 0x00EC},
{0x00CD, 0x00ED},
{0x00CE, 0x00EE},
{0x00CF, 0x00EF},
{0x00D0, 0x00F0},
{0x00D1, 0x00F1},
{0x00D2, 0x00F2},
{0x00D3, 0x00F3},
{0x00D4, 0x00F4},
{0x00D5, 0x00F5},
{0x00D6, 0x00F6},
{0x00D8, 0x00F8},
{0x00D9, 0x00F9},
{0x00DA, 0x00FA},
{0x00DB, 0x00FB},
{0x00DC, 0x00FC},
{0x00DD, 0x00FD},
{0x00DE, 0x00FE},
{0x0100, 0x0101},
{0x0102, 0x0103},
{0x0104, 0x0105},
{0x0106, 0x0107},
{0x0108, 0x0109},
{0x010A, 0x010B},
{0x010C, 0x010D},
{0x010E, 0x010F},
{0x0110, 0x0111},
{0x0112, 0x0113},
{0x0114, 0x0115},
{0x0116, 0x0117},
{0x0118, 0x0119},
{0x011A, 0x011B},
{0x011C, 0x011D},
{0x011E, 0x011F},
{0x0120, 0x0121},
{0x0122, 0x0123},
{0x0124, 0x0125},
{0x0126, 0x0127},
{0x0128, 0x0129},
{0x012A, 0x012B},
{0x012C, 0x012D},
{0x012E, 0x012F},
{0x0130, 0x0069},
{0x0132, 0x0133},
{0x0134, 0x0135},
{0x0136, 0x0137},
{0x0139, 0x013A},
{0x013B, 0x013C},
{0x013D, 0x013E},
{0x013F, 0x0140},
{0x0141, 0x0142},
{0x0143, 0x0144},
{0x0145, 0x0146},
{0x0147, 0x0148},
{0x014A, 0x014B},
{0x014C, 0x014D},
{0x014E, 0x014F},
{0x0150, 0x0151},
{0x0152, 0x0153},
{0x0154, 0x0155},
{0x0156, 0x0157},
{0x0158, 0x0159},
{0x015A, 0x015B},
{0x015C, 0x015D},
{0x015E, 0x015F},
{0x0160, 0x0161},
{0x0162, 0x0163},
{0x0164, 0x0165},
{0x0166, 0x0167},
{0x0168, 0x0169},
{0x016A, 0x016B},
{0x016C, 0x016D},
{0x016E, 0x016F},
{0x0170, 0x0171},
{0x0172, 0x0173},
{0x0174, 0x0175},
{0x0176, 0x0177},
{0x0178, 0x00FF},
{0x0179, 0x017A},
{0x017B, 0x017C},
{0x017D, 0x017E},
{0x0181, 0x0253},
{0x0182, 0x0183},
{0x0184, 0x0185},
{0x0186, 0x0254},
{0x0187, 0x0188},
{0x0189, 0x0256},
{0x018A, 0x0257},
{0x018B, 0x018C},
{0x018E, 0x01DD},
{0x018F, 0x0259},
{0x0190, 0x025B},
{0x0191, 0x0192},
{0x0193, 0x0260},
{0x0194, 0x0263},
{0x0196, 0x0269},
{0x0197, 0x0268},
{0x0198, 0x0199},
{0x019C, 0x026F},
{0x019D, 0x0272},
{0x019F, 0x0275},
{0x01A0, 0x01A1},
{0x01A2, 0x01A3},
{0x01A4, 0x01A5},
{0x01A6, 0x0280},
{0x01A7, 0x01A8},
{0x01A9, 0x0283},
{0x01AC, 0x01AD},
{0x01AE, 0x0288},
{0x01AF, 0x01B0},
{0x01B1, 0x028A},
{0x01B2, 0x028B},
{0x01B3, 0x01B4},
{0x01B5, 0x01B6},
{0x01B7, 0x0292},
{0x01B8, 0x01B9},
{0x01BC, 0x01BD},
{0x01C4, 0x01C6},
{0x01C5, 0x01C6},
{0x01C7, 0x01C9},
{0x01C8, 0x01C9},
{0x01CA, 0x01CC},
{0x01CB, 0x01CC},
{0x01CD, 0x01CE},
{0x01CF, 0x01D0},
{0x01D1, 0x01D2},
{0x01D3, 0x01D4},
{0x01D5, 0x01D6},
{0x01D7, 0x01D8},
{0x01D9, 0x01DA},
{0x01DB, 0x01DC},
{0x01DE, 0x01DF},
{0x01E0, 0x01E1},
{0x01E2, 0x01E3},
{0x01E4, 0x01E5},
{0x01E6, 0x01E7},
{0x01E8, 0x01E9},
{0x01EA, 0x01EB},
{0x01EC, 0x01ED},
{0x01EE, 0x01EF},
{0x01F1, 0x01F3},
{0x01F2, 0x01F3},
{0x01F4, 0x01F5},
{0x01F6, 0x0195},
{0x01F7, 0x01BF},
{0x01F8, 0x01F9},
{0x01FA, 0x01FB},
{0x01FC, 0x01FD},
{0x01FE, 0x01FF},
{0x0200, 0x0201},
{0x0202, 0x0203},
{0x0204, 0x0205},
{0x0206, 0x0207},
{0x0208, 0x0209},
{0x020A, 0x020B},
{0x020C, 0x020D},
{0x020E, 0x020F},
{0x0210, 0x0211},
{0x0212, 0x0213},
{0x0214, 0x0215},
{0x0216, 0x0217},
{0x0218, 0x0219},
{0x021A, 0x021B},
{0x021C, 0x021D},
{0x021E, 0x021F},
{0x0220, 0x019E},
{0x0222, 0x0223},
{0x0224, 0x0225},
{0x0226, 0x0227},
{0x0228, 0x0229},
{0x022A, 0x022B},
{0x022C, 0x022D},
{0x022E, 0x022F},
{0x0230, 0x0231},
{0x0232, 0x0233},
{0x023A, 0x2C65},
{0x023B, 0x023C},
{0x023D, 0x019A},
{0x023E, 0x2C66},
{0x0241, 0x0242},
{0x0243, 0x0180},
{0x0244, 0x0289},
{0x0245, 0x028C},
{0x0246, 0x0247},
{0x0248, 0x0249},
{0x024A, 0x024B},
{0x024C, 0x024D},
{0x024E, 0x024F},
{0x0370, 0x0371},
{0x0372, 0x0373},
{0x0376, 0x0377},
{0x037F, 0x03F3},
{0x0386, 0x03AC},
{0x0388, 0x03AD},
{0x0389, 0x03AE},
{0x038A, 0x03AF},
{0x038C, 0x03CC},
{0x038E, 0x03CD},
{0x038F, 0x03CE},
{0x0391, 0x03B1},
{0x0392, 0x03B2},
{0x0393, 0x03B3},
{0x0394, 0x03B4},
{0x0395, 0x03B5},
{0x0396, 0x03B6},
{0x0397, 0x03B7},
{0x0398, 0x03B8},
{0x0399, 0x03B9},
{0x039A, 0x03BA},
{0x039B, 0x03BB},
{0x039C, 0x03BC},
{0x039D, 0x03BD},
{0x039E, 0x03BE},
{0x039F, 0x03BF},
{0x03A0, 0x03C0},
{0x03A1, 0x03C1},
{0x03A3, 0x03C3},
{0x03A4, 0x03C4},
{0x03A5, 0x03C5},
{0x03A6, 0x03C6},
{0x03A7, 0x03C7},
{0x03A8, 0x03C8},
{0x03A9, 0x03C9},
{0x03AA, 0x03CA},
{0x03AB, 0x03CB},
{0x03CF, 0x03D7},
{0x03D8, 0x03D9},
{0x03DA, 0x03DB},
{0x03DC, 0x03DD},
{0x03DE, 0x03DF},
{0x03E0, 0x03E1},
{0x03E2, 0x03E3},
{0x03E4, 0x03E5},
{0x03E6, 0x03E7},
{0x03E8, 0x03E9},
{0x03EA, 0x03EB},
{0x03EC, 0x03ED},
{0x03EE, 0x03EF},
{0x03F4, 0x03B8},
{0x03F7, 0x03F8},
{0x03F9, 0x03F2},
{0x03FA, 0x03FB},
{0x03FD, 0x037B},
{0x03FE, 0x037C},
{0x03FF, 0x037D},
{0x0400, 0x0450},
{0x0401, 0x0451},
{0x0402, 0x0452},
{0x0403, 0x0453},
{0x0404, 0x0454},
{0x0405, 0x0455},
{0x0406, 0x0456},
{0x0407, 0x0457},
{0x0408, 0x0458},
{0x0409, 0x0459},
{0x040A, 0x045A},
{0x040B, 0x045B},
{0x040C, 0x045C},
{0x040D, 0x045D},
{0x040E, 0x045E},
{0x040F, 0x045F},
{0x0410, 0x0430},
{0x0411, 0x0431},
{0x0412, 0x0432},
{0x0413, 0x0433},
{0x0414, 0x0434},
{0x0415, 0x0435},
{0x0416, 0x0436},
{0x0417, 0x0437},
{0x0418, 0x0438},
{0x0419, 0x0439},
{0x041A, 0x043A},
{0x041B, 0x043B},
{0x041C, 0x043C},
{0x041D, 0x043D},
{0x041E, 0x043E},
{0x041F, 0x043F},
{0x0420, 0x0440},
{0x0421, 0x0441},
{0x0422, 0x0442},
{0x0423, 0x0443},
{0x0424, 0x0444},
{0x0425, 0x0445},
{0x0426, 0x0446},
{0x0427, 0x0447},
{0x0428, 0x0448},
{0x0429, 0x0449},
{0x042A, 0x044A},
{0x042B, 0x044B},
{0x042C, 0x044C},
{0x042D, 0x044D},
{0x042E, 0x044E},
{0x042F, 0x044F},
{0x0460, 0x0461},
{0x0462, 0x0463},
{0x0464, 0x0465},
{0x0466, 0x0467},
{0x0468, 0x0469},
{0x046A, 0x046B},
{0x046C, 0x046D},
{0x046E, 0x046F},
{0x0470, 0x0471},
{0x0472, 0x0473},
{0x0474, 0x0475},
{0x0476, 0x0477},
{0x0478, 0x0479},
{0x047A, 0x047B},
{0x047C, 0x047D},
{0x047E, 0x047F},
{0x0480, 0x0481},
{0x048A, 0x048B},
{0x048C, 0x048D},
{0x048E, 0x048F},
{0x0490, 0x0491},
{0x0492, 0x0493},
{0x0494, 0x0495},
{0x0496, 0x0497},
{0x0498, 0x0499},
{0x049A, 0x049B},
{0x049C, 0x049D},
{0x049E, 0x049F},
{0x04A0, 0x04A1},
{0x04A2, 0x04A3},
{0x04A4, 0x04A5},
{0x04A6, 0x04A7},
{0x04A8, 0x04A9},
{0x04AA, 0x04AB},
{0x04AC, 0x04AD},
{0x04AE, 0x04AF},
{0x04B0, 0x04B1},
{0x04B2, 0x04B3},
{0x04B4, 0x04B5},
{0x04B6, 0x04B7},
{0x04B8, 0x04B9},
{0x04BA, 0x04BB},
{0x04BC, 0x04BD},
{0x04BE, 0x04BF},
{0x04C0, 0x04CF},
{0x04C1, 0x04C2},
{0x04C3, 0x04C4},
{0x04C5, 0x04C6},
{0x04C7, 0x04C8},
{0x04C9, 0x04CA},
{0x04CB, 0x04CC},
{0x04CD, 0x04CE},
{0x04D0, 0x04D1},
{0x04D2, 0x04D3},
{0x04D4, 0x04D5},
{0x04D6, 0x04D7},
{0x04D8, 0x04D9},
{0x04DA, 0x04DB},
{0x04DC, 0x04DD},
{0x04DE, 0x04DF},
{0x04E0, 0x04E1},
{0x04E2, 0x04E3},
{0x04E4, 0x04E5},
{0x04E6, 0x04E7},
{0x04E8, 0x04E9},
{0x04EA, 0x04EB},
{0x04EC, 0x04ED},
{0x04EE, 0x04EF},
{0x04F0, 0x04F1},
{0x04F2, 0x04F3},
{0x04F4, 0x04F5},
{0x04F6, 0x04F7},
{0x04F8, 0x04F9},
{0x04FA, 0x04FB},
{0x04FC, 0x04FD},
{0x04FE, 0x04FF},
{0x0500, 0x0501},
{0x0502, 0x0503},
{0x0504, 0x0505},
{0x0506, 0x0507},
{0x0508, 0x0509},
{0x050A, 0x050B},
{0x050C, 0x050D},
{0x050E, 0x050F},
{0x0510, 0x0511},
{0x0512, 0x0513},
{0x0514, 0x0515},
{0x0516, 0x0517},
{0x0518, 0x0519},
{0x051A, 0x051B},
{0x051C, 0x051D},
{0x051E, 0x051F},
{0x0520, 0x0521},
{0x0522, 0x0523},
{0x0524, 0x0525},
{0x0526, 0x0527},
{0x0528, 0x0529},
{0x052A, 0x052B},
{0x052C, 0x052D},
{0x052E, 0x052F},
{0x0531, 0x0561},
{0x0532, 0x0562},
{0x0533, 0x0563},
{0x0534, 0x0564},
{0x0535, 0x0565},
{0x0536, 0x0566},
{0x0537, 0x0567},
{0x0538, 0x0568},
{0x0539, 0x0569},
{0x053A, 0x056A},
{0x053B, 0x056B},
{0x053C, 0x056C},
{0x053D, 0x056D},
{0x053E, 0x056E},
{0x053F, 0x056F},
{0x0540, 0x0570},
{0x0541, 0x0571},
{0x0542, 0x0572},
{0x0543, 0x0573},
{0x0544, 0x0574},
{0x0545, 0x0575},
{0x0546, 0x0576},
{0x0547, 0x0577},
{0x0548, 0x0578},
{0x0549, 0x0579},
{0x054A, 0x057A},
{0x054B, 0x057B},
{0x054C, 0x057C},
{0x054D, 0x057D},
{0x054E, 0x057E},
{0x054F, 0x057F},
{0x0550, 0x0580},
{0x0551, 0x0581},
{0x0552, 0x0582},
{0x0553, 0x0583},
{0x0554, 0x0584},
{0x0555, 0x0585},
{0x0556, 0x0586},
{0x10A0, 0x2D00},
{0x10A1, 0x2D01},
{0x10A2, 0x2D02},
{0x10A3, 0x2D03},
{0x10A4, 0x2D04},
{0x10A5, 0x2D05},
{0x10A6, 0x2D06},
{0x10A7, 0x2D07},
{0x10A8, 0x2D08},
{0x10A9, 0x2D09},
{0x10AA, 0x2D0A},
{0x10AB, 0x2D0B},
{0x10AC, 0x2D0C},
{0x10AD, 0x2D0D},
{0x10AE, 0x2D0E},
{0x10AF, 0x2D0F},
{0x10B0, 0x2D10},
{0x10B1, 0x2D11},
{0x10B2, 0x2D12},
{0x10B3, 0x2D13},
{0x10B4, 0x2D14},
{0x10B5, 0x2D15},
{0x10B6, 0x2D16},
{0x10B7, 0x2D17},
{0x10B8, 0x2D18},
{0x10B9, 0x2D19},
{0x10BA, 0x2D1A},
{0x10BB, 0x2D1B},
{0x10BC, 0x2D1C},
{0x10BD, 0x2D1D},
{0x10BE, 0x2D1E},
{0x10BF, 0x2D1F},
{0x10C0, 0x2D20},
{0x10C1, 0x2D21},
{0x10C2, 0x2D22},
{0x10C3, 0x2D23},
{0x10C4, 0x2D24},
{0x10C5, 0x2D25},
{0x10C7, 0x2D27},
{0x10CD, 0x2D2D},
{0x13A0, 0xAB70},
{0x13A1, 0xAB71},
{0x13A2, 0xAB72},
{0x13A3, 0xAB73},
{0x13A4, 0xAB74},
{0x13A5, 0xAB75},
{0x13A6, 0xAB76},
{0x13A7, 0xAB77},
{0x13A8, 0xAB78},
{0x13A9, 0xAB79},
{0x13AA, 0xAB7A},
{0x13AB, 0xAB7B},
{0x13AC, 0xAB7C},
{0x13AD, 0xAB7D},
{0x13AE, 0xAB7E},
{0x13AF, 0xAB7F},
{0x13B0, 0xAB80},
{0x13B1, 0xAB81},
{0x13B2, 0xAB82},
{0x13B3, 0xAB83},
{0x13B4, 0xAB84},
{0x13B5, 0xAB85},
{0x13B6, 0xAB86},
{0x13B7, 0xAB87},
{0x13B8, 0xAB88},
{0x13B9, 0xAB89},
{0x13BA, 0xAB8A},
{0x13BB, 0xAB8B},
{0x13BC, 0xAB8C},
{0x13BD, 0xAB8D},
{0x13BE, 0xAB8E},
{0x13BF, 0xAB8F},
{0x13C0, 0xAB90},
{0x13C1, 0xAB91},
{0x13C2, 0xAB92},
{0x13C3, 0xAB93},
{0x13C4, 0xAB94},
{0x13C5, 0xAB95},
{0x13C6, 0xAB96},
{0x13C7, 0xAB97},
{0x13C8, 0xAB98},
{0x13C9, 0xAB99},
{0x13CA, 0xAB9A},
{0x13CB, 0xAB9B},
{0x13CC, 0xAB9C},
{0x13CD, 0xAB9D},
{0x13CE, 0xAB9E},
{0x13CF, 0xAB9F},
{0x13D0, 0xABA0},
{0x13D1, 0xABA1},
{0x13D2, 0xABA2},
{0x13D3, 0xABA3},
{0x13D4, 0xABA4},
{0x13D5, 0xABA5},
{0x13D6, 0xABA6},
{0x13D7, 0xABA7},
{0x13D8, 0xABA8},
{0x13D9, 0xABA9},
{0x13DA, 0xABAA},
{0x13DB, 0xABAB},
{0x13DC, 0xABAC},
{0x13DD, 0xABAD},
{0x13DE, 0xABAE},
{0x13DF, 0xABAF},
{0x13E0, 0xABB0},
{0x13E1, 0xABB1},
{0x13E2, 0xABB2},
{0x13E3, 0xABB3},
{0x13E4, 0xABB4},
{0x13E5, 0xABB5},
{0x13E6, 0xABB6},
{0x13E7, 0xABB7},
{0x13E8, 0xABB8},
{0x13E9, 0xABB9},
{0x13EA, 0xABBA},
{0x13EB, 0xABBB},
{0x13EC, 0xABBC},
{0x13ED, 0xABBD},
{0x13EE, 0xABBE},
{0x13EF, 0xABBF},
{0x13F0, 0x13F8},
{0x13F1, 0x13F9},
{0x13F2, 0x13FA},
{0x13F3, 0x13FB},
{0x13F4, 0x13FC},
{0x13F5, 0x13FD},
{0x1C89, 0x1C8A},
{0x1C90, 0x10D0},
{0x1C91, 0x10D1},
{0x1C92, 0x10D2},
{0x1C93, 0x10D3},
{0x1C94, 0x10D4},
{0x1C95, 0x10D5},
{0x1C96, 0x10D6},
{0x1C97, 0x10D7},
{0x1C98, 0x10D8},
{0x1C99, 0x10D9},
{0x1C9A, 0x10DA},
{0x1C9B, 0x10DB},
{0x1C9C, 0x10DC},
{0x1C9D, 0x10DD},
{0x1C9E, 0x10DE},
{0x1C9F, 0x10DF},
{0x1CA0, 0x10E0},
{0x1CA1, 0x10E1},
{0x1CA2, 0x10E2},
{0x1CA3, 0x10E3},
{0x1CA4, 0x10E4},
{0x1CA5, 0x10E5},
{0x1CA6, 0x10E6},
{0x1CA7, 0x10E7},
{0x1CA8, 0x10E8},
{0x1CA9, 0x10E9},
{0x1CAA, 0x10EA},
{0x1CAB, 0x10EB},
{0x1CAC, 0x10EC},
{0x1CAD, 0x10ED},
{0x1CAE, 0x10EE},
{0x1CAF, 0x10EF},
{0x1CB0, 0x10F0},
{0x1CB1, 0x10F1},
{0x1CB2, 0x10F2},
{0x1CB3, 0x10F3},
{0x1CB4, 0x10F4},
{0x1CB5, 0x10F5},
{0x1CB6, 0x10F6},
{0x1CB7, 0x10F7},
{0x1CB8, 0x10F8},
{0x1CB9, 0x10F9},
{0x1CBA, 0x10FA},
{0x1CBD, 0x10FD},
{0x1CBE, 0x10FE},
{0x1CBF, 0x10FF},
{0x1E00, 0x1E01},
{0x1E02, 0x1E03},
{0x1E04, 0x1E05},
{0x1E06, 0x1E07},
{0x1E08, 0x1E09},
{0x1E0A, 0x1E0B},
{0x1E0C, 0x1E0D},
{0x1E0E, 0x1E0F},
{0x1E10, 0x1E11},
{0x1E12, 0x1E13},
{0x1E14, 0x1E15},
{0x1E16, 0x1E17},
{0x1E18, 0x1E19},
{0x1E1A, 0x1E1B},
{0x1E1C, 0x1E1D},
{0x1E1E, 0x1E1F},
{0x1E20, 0x1E21},
{0x1E22, 0x1E23},
{0x1E24, 0x1E25},
{0x1E26, 0x1E27},
{0x1E28, 0x1E29},
{0x1E2A, 0x1E2B},
{0x1E2C, 0x1E2D},
{0x1E2E, 0x1E2F},
{0x1E30, 0x1E31},
{0x1E32, 0x1E33},
{0x1E34, 0x1E35},
{0x1E36, 0x1E37},
{0x1E38, 0x1E39},
{0x1E3A, 0x1E3B},
{0x1E3C, 0x1E3D},
{0x1E3E, 0x1E3F},
{0x1E40, 0x1E41},
{0x1E42, 0x1E43},
{0x1E44, 0x1E45},
{0x1E46, 0x1E47},
{0x1E48, 0x1E49},
{0x1E4A, 0x1E4B},
{0x1E4C, 0x1E4D},
{0x1E4E, 0x1E4F},
{0x1E50, 0x1E51},
{0x1E52, 0x1E53},
{0x1E54, 0x1E55},
{0x1E56, 0x1E57},
{0x1E58, 0x1E59},
{0x1E5A, 0x1E5B},
{0x1E5C, 0x1E5D},
{0x1E5E, 0x1E5F},
{0x1E60, 0x1E61},
{0x1E62, 0x1E63},
{0x1E64, 0x1E65},
{0x1E66, 0x1E67},
{0x1E68, 0x1E69},
{0x1E6A, 0x1E6B},
{0x1E6C, 0x1E6D},
{0x1E6E, 0x1E6F},
{0x1E70, 0x1E71},
{0x1E72, 0x1E73},
{0x1E74, 0x1E75},
{0x1E76, 0x1E77},
{0x1E78, 0x1E79},
{0x1E7A, 0x1E7B},
{0x1E7C, 0x1E7D},
{0x1E7E, 0x1E7F},
{0x1E80, 0x1E81},
{0x1E82, 0x1E83},
{0x1E84, 0x1E85},
{0x1E86, 0x1E87},
{0x1E88, 0x1E89},
{0x1E8A, 0x1E8B},
{0x1E8C, 0x1E8D},
{0x1E8E, 0x1E8F},
{0x1E90, 0x1E91},
{0x1E92, 0x1E93},
{0x1E94, 0x1E95},
{0x1E9E, 0x00DF},
{0x1EA0, 0x1EA1},
{0x1EA2, 0x1EA3},
{0x1EA4, 0x1EA5},
{0x1EA6, 0x1EA7},
{0x1EA8, 0x1EA9},
{0x1EAA, 0x1EAB},
{0x1EAC, 0x1EAD},
{0x1EAE, 0x1EAF},
{0x1EB0, 0x1EB1},
{0x1EB2, 0x1EB3},
{0x1EB4, 0x1EB5},
{0x1EB6, 0x1EB7},
{0x1EB8, 0x1EB9},
{0x1EBA, 0x1EBB},
{0x1EBC, 0x1EBD},
{0x1EBE, 0x1EBF},
{0x1EC0, 0x1EC1},
{0x1EC2, 0x1EC3},
{0x1EC4, 0x1EC5},
{0x1EC6, 0x1EC7},
{0x1EC8, 0x1EC9},
{0x1ECA, 0x1ECB},
{0x1ECC, 0x1ECD},
{0x1ECE, 0x1ECF},
{0x1ED0, 0x1ED1},
{0x1ED2, 0x1ED3},
{0x1ED4, 0x1ED5},
{0x1ED6, 0x1ED7},
{0x1ED8, 0x1ED9},
{0x1EDA, 0x1EDB},
{0x1EDC, 0x1EDD},
{0x1EDE, 0x1EDF},
{0x1EE0, 0x1EE1},
{0x1EE2, 0x1EE3},
{0x1EE4, 0x1EE5},
{0x1EE6, 0x1EE7},
{0x1EE8, 0x1EE9},
{0x1EEA, 0x1EEB},
{0x1EEC, 0x1EED},
{0x1EEE, 0x1EEF},
{0x1EF0, 0x1EF1},
{0x1EF2, 0x1EF3},
{0x1EF4, 0x1EF5},
{0x1EF6, 0x1EF7},
{0x1EF8, 0x1EF9},
{0x1EFA, 0x1EFB},
{0x1EFC, 0x1EFD},
{0x1EFE, 0x1EFF},
{0x1F08, 0x1F00},
{0x1F09, 0x1F01},
{0x1F0A, 0x1F02},
{0x1F0B, 0x1F03},
{0x1F0C, 0x1F04},
{0x1F0D, 0x1F05},
{0x1F0E, 0x1F06},
{0x1F0F, 0x1F07},
{0x1F18, 0x1F10},
{0x1F19, 0x1F11},
{0x1F1A, 0x1F12},
{0x1F1B, 0x1F13},
{0x1F1C, 0x1F14},
{0x1F1D, 0x1F15},
{0x1F28, 0x1F20},
{0x1F29, 0x1F21},
{0x1F2A, 0x1F22},
{0x1F2B, 0x1F23},
{0x1F2C, 0x1F24},
{0x1F2D, 0x1F25},
{0x1F2E, 0x1F26},
{0x1F2F, 0x1F27},
{0x1F38, 0x1F30},
{0x1F39, 0x1F31},
{0x1F3A, 0x1F32},
{0x1F3B, 0x1F33},
{0x1F3C, 0x1F34},
{0x1F3D, 0x1F35},
{0x1F3E, 0x1F36},
{0x1F3F, 0x1F37},
{0x1F48, 0x1F40},
{0x1F49, 0x1F41},
{0x1F4A, 0x1F42},
{0x1F4B, 0x1F43},
{0x1F4C, 0x1F44},
{0x1F4D, 0x1F45},
{0x1F59, 0x1F51},
{0x1F5B, 0x1F53},
{0x1F5D, 0x1F55},
{0x1F5F, 0x1F57},
{0x1F68, 0x1F60},
{0x1F69, 0x1F61},
{0x1F6A, 0x1F62},
{0x1F6B, 0x1F63},
{0x1F6C, 0x1F64},
{0x1F6D, 0x1F65},
{0x1F6E, 0x1F66},
{0x1F6F, 0x1F67},
{0x1F88, 0x1F80},
{0x1F89, 0x1F81},
{0x1F8A, 0x1F82},
{0x1F8B, 0x1F83},
{0x1F8C, 0x1F84},
{0x1F8D, 0x1F85},
{0x1F8E, 0x1F86},
{0x1F8F, 0x1F87},
{0x1F98, 0x1F90},
{0x1F99, 0x1F91},
{0x1F9A, 0x1F92},
{0x1F9B, 0x1F93},
{0x1F9C, 0x1F94},
{0x1F9D, 0x1F95},
{0x1F9E, 0x1F96},
{0x1F9F, 0x1F97},
{0x1FA8, 0x1FA0},
{0x1FA9, 0x1FA1},
{0x1FAA, 0x1FA2},
{0x1FAB, 0x1FA3},
{0x1FAC, 0x1FA4},
{0x1FAD, 0x1FA5},
{0x1FAE, 0x1FA6},
{0x1FAF, 0x1FA7},
{0x1FB8, 0x1FB0},
{0x1FB9, 0x1FB1},
{0x1FBA, 0x1F70},
{0x1FBB, 0x1F71},
{0x1FBC, 0x1FB3},
{0x1FC8, 0x1F72},
{0x1FC9, 0x1F73},
{0x1FCA, 0x1F74},
{0x1FCB, 0x1F75},
{0x1FCC, 0x1FC3},
{0x1FD8, 0x1FD0},
{0x1FD9, 0x1FD1},
{0x1FDA, 0x1F76},
{0x1FDB, 0x1F77},
{0x1FE8, 0x1FE0},
{0x1FE9, 0x1FE1},
{0x1FEA, 0x1F7A},
{0x1FEB, 0x1F7B},
{0x1FEC, 0x1FE5},
{0x1FF8, 0x1F78},
{0x1FF9, 0x1F79},
{0x1FFA, 0x1F7C},
{0x1FFB, 0x1F7D},
{0x1FFC, 0x1FF3},
{0x2126, 0x03C9},
{0x212A, 0x006B},
{0x212B, 0x00E5},
{0x2132, 0x214E},
{0x2160, 0x2170},
{0x2161, 0x2171},
{0x2162, 0x2172},
{0x2163, 0x2173},
{0x2164, 0x2174},
{0x2165, 0x2175},
{0x2166, 0x2176},
{0x2167, 0x2177},
{0x2168, 0x2178},
{0x2169, 0x2179},
{0x216A, 0x217A},
{0x216B, 0x217B},
{0x216C, 0x217C},
{0x216D, 0x217D},
{0x216E, 0x217E},
{0x216F, 0x217F},
{0x2183, 0x2184},
{0x24B6, 0x24D0},
{0x24B7, 0x24D1},
{0x24B8, 0x24D2},
{0x24B9, 0x24D3},
{0x24BA, 0x24D4},
{0x24BB, 0x24D5},
{0x24BC, 0x24D6},
{0x24BD, 0x24D7},
{0x24BE, 0x24D8},
{0x24BF, 0x24D9},
{0x24C0, 0x24DA},
{0x24C1, 0x24DB},
{0x24C2, 0x24DC},
{0x24C3, 0x24DD},
{0x24C4, 0x24DE},
{0x24C5, 0x24DF},
{0x24C6, 0x24E0},
{0x24C7, 0x24E1},
{0x24C8, 0x24E2},
{0x24C9, 0x24E3},
{0x24CA, 0x24E4},
{0x24CB, 0x24E5},
{0x24CC, 0x24E6},
{0x24CD, 0x24E7},
{0x24CE, 0x24E8},
{0x24CF, 0x24E9},
{0x2C00, 0x2C30},
{0x2C01, 0x2C31},
{0x2C02, 0x2C32},
{0x2C03, 0x2C33},
{0x2C04, 0x2C34},
{0x2C05, 0x2C35},
{0x2C06, 0x2C36},
{0x2C07, 0x2C37},
{0x2C08, 0x2C38},
{0x2C09, 0x2C39},
{0x2C0A, 0x2C3A},
{0x2C0B, 0x2C3B},
{0x2C0C, 0x2C3C},
{0x2C0D, 0x2C3D},
{0x2C0E, 0x2C3E},
{0x2C0F, 0x2C3F},
{0x2C10, 0x2C40},
{0x2C11, 0x2C41},
{0x2C12, 0x2C42},
{0x2C13, 0x2C43},
{0x2C14, 0x2C44},
{0x2C15, 0x2C45},
{0x2C16, 0x2C46},
{0x2C17, 0x2C47},
{0x2C18, 0x2C48},
{0x2C19, 0x2C49},
{0x2C1A, 0x2C4A},
{0x2C1B, 0x2C4B},
{0x2C1C, 0x2C4C},
{0x2C1D, 0x2C4D},
{0x2C1E, 0x2C4E},
{0x2C1F, 0x2C4F},
{0x2C20, 0x2C50},
{0x2C21, 0x2C51},
{0x2C22, 0x2C52},
{0x2C23, 0x2C53},
{0x2C24, 0x2C54},
{0x2C25, 0x2C55},
{0x2C26, 0x2C56},
{0x2C27, 0x2C57},
{0x2C28, 0x2C58},
{0x2C29, 0x2C59},
{0x2C2A, 0x2C5A},
{0x2C2B, 0x2C5B},
{0x2C2C, 0x2C5C},
{0x2C2D, 0x2C5D},
{0x2C2E, 0x2C5E},
{0x2C2F, 0x2C5F},
{0x2C60, 0x2C61},
{0x2C62, 0x026B},
{0x2C63, 0x1D7D},
{0x2C64, 0x027D},
{0x2C67, 0x2C68},
{0x2C69, 0x2C6A},
{0x2C6B, 0x2C6C},
{0x2C6D, 0x0251},
{0x2C6E, 0x0271},
{0x2C6F, 0x0250},
{0x2C70, 0x0252},
{0x2C72, 0x2C73},
{0x2C75, 0x2C76},
{0x2C7E, 0x023F},
{0x2C7F, 0x0240},
{0x2C80, 0x2C81},
{0x2C82, 0x2C83},
{0x2C84, 0x2C85},
{0x2C86, 0x2C87},
{0x2C88, 0x2C89},
{0x2C8A, 0x2C8B},
{0x2C8C, 0x2C8D},
{0x2C8E, 0x2C8F},
{0x2C90, 0x2C91},
{0x2C92, 0x2C93},
{0x2C94, 0x2C95},
{0x2C96, 0x2C97},
{0x2C98, 0x2C99},
{0x2C9A, 0x2C9B},
{0x2C9C, 0x2C9D},
{0x2C9E, 0x2C9F},
{0x2CA0, 0x2CA1},
{0x2CA2, 0x2CA3},
{0x2CA4, 0x2CA5},
{0x2CA6, 0x2CA7},
{0x2CA8, 0x2CA9},
{0x2CAA, 0x2CAB},
{0x2CAC, 0x2CAD},
{0x2CAE, 0x2CAF},
{0x2CB0, 0x2CB1},
{0x2CB2, 0x2CB3},
{0x2CB4, 0x2CB5},
{0x2CB6, 0x2CB7},
{0x2CB8, 0x2CB9},
{0x2CBA, 0x2CBB},
{0x2CBC, 0x2CBD},
{0x2CBE, 0x2CBF},
{0x2CC0, 0x2CC1},
{0x2CC2, 0x2CC3},
{0x2CC4, 0x2CC5},
{0x2CC6, 0x2CC7},
{0x2CC8, 0x2CC9},
{0x2CCA, 0x2CCB},
{0x2CCC, 0x2CCD},
{0x2CCE, 0x2CCF},
{0x2CD0, 0x2CD1},
{0x2CD2, 0x2CD3},
{0x2CD4, 0x2CD5},
{0x2CD6, 0x2CD7},
{0x2CD8, 0x2CD9},
{0x2CDA, 0x2CDB},
{0x2CDC, 0x2CDD},
{0x2CDE, 0x2CDF},
{0x2CE0, 0x2CE1},
{0x2CE2, 0x2CE3},
{0x2CEB, 0x2CEC},
{0x2CED, 0x2CEE},
{0x2CF2, 0x2CF3},
{0xA640, 0xA641},
{0xA642, 0xA643},
{0xA644, 0xA645},
{0xA646, 0xA647},
{0xA648, 0xA649},
{0xA64A, 0xA64B},
{0xA64C, 0xA64D},
{0xA64E, 0xA64F},
{0xA650, 0xA651},
{0xA652, 0xA653},
{0xA654, 0xA655},
{0xA656, 0xA657},
{0xA658, 0xA659},
{0xA65A, 0xA65B},
{0xA65C, 0xA65D},
{0xA65E, 0xA65F},
{0xA660, 0xA661},
{0xA662, 0xA663},
{0xA664, 0xA665},
{0xA666, 0xA667},
{0xA668, 0xA669},
{0xA66A, 0xA66B},
{0xA66C, 0xA66D},
{0xA680, 0xA681},
{0xA682, 0xA683},
{0xA684, 0xA685},
{0xA686, 0xA687},
{0xA688, 0xA689},
{0xA68A, 0xA68B},
{0xA68C, 0xA68D},
{0xA68E, 0xA68F},
{0xA690, 0xA691},
{0xA692, 0xA693},
{0xA694, 0xA695},
{0xA696, 0xA697},
{0xA698, 0xA699},
{0xA69A, 0xA69B},
{0xA722, 0xA723},
{0xA724, 0xA725},
{0xA726, 0xA727},
{0xA728, 0xA729},
{0xA72A, 0xA72B},
{0xA72C, 0xA72D},
{0xA72E, 0xA72F},
{0xA732, 0xA733},
{0xA734, 0xA735},
{0xA736, 0xA737},
{0xA738, 0xA739},
{0xA73A, 0xA73B},
{0xA73C, 0xA73D},
{0xA73E, 0xA73F},
{0xA740, 0xA741},
{0xA742, 0xA743},
{0xA744, 0xA745},
{0xA746, 0xA747},
{0xA748, 0xA749},
{0xA74A, 0xA74B},
{0xA74C, 0xA74D},
{0xA74E, 0xA74F},
{0xA750, 0xA751},
{0xA752, 0xA753},
{0xA754, 0xA755},
{0xA756, 0xA757},
{0xA758, 0xA759},
{0xA75A, 0xA75B},
{0xA75C, 0xA75D},
{0xA75E, 0xA75F},
{0xA760, 0xA761},
{0xA762, 0xA763},
{0xA764, 0xA765},
{0xA766, 0xA767},
{0xA768, 0xA769},
{0xA76A, 0xA76B},
{0xA76C, 0xA76D},
{0xA76E, 0xA76F},
{0xA779, 0xA77A},
{0xA77B, 0xA77C},
{0xA77D, 0x1D79},
{0xA77E, 0xA77F},
{0xA780, 0xA781},
{0xA782, 0xA783},
{0xA784, 0xA785},
{0xA786, 0xA787},
{0xA78B, 0xA78C},
{0xA78D, 0x0265},
{0xA790, 0xA791},
{0xA792, 0xA793},
{0xA796, 0xA797},
{0xA798, 0xA799},
{0xA79A, 0xA79B},
{0xA79C, 0xA79D},
{0xA79E, 0xA79F},
{0xA7A0, 0xA7A1},
{0xA7A2, 0xA7A3},
{0xA7A4, 0xA7A5},
{0xA7A6, 0xA7A7},
{0xA7A8, 0xA7A9},
{0xA7AA, 0x0266},
{0xA7AB, 0x025C},
{0xA7AC, 0x0261},
{0xA7AD, 0x026C},
{0xA7AE, 0x026A},
{0xA7B0, 0x029E},
{0xA7B1, 0x0287},
{0xA7B2, 0x029D},
{0xA7B3, 0xAB53},
{0xA7B4, 0xA7B5},
{0xA7B6, 0xA7B7},
{0xA7B8, 0xA7B9},
{0xA7BA, 0xA7BB},
{0xA7BC, 0xA7BD},
{0xA7BE, 0xA7BF},
{0xA7C0, 0xA7C1},
{0xA7C2, 0xA7C3},
{0xA7C4, 0xA794},
{0xA7C5, 0x0282},
{0xA7C6, 0x1D8E},
{0xA7C7, 0xA7C8},
{0xA7C9, 0xA7CA},
{0xA7CB, 0x0264},
{0xA7CC, 0xA7CD},
{0xA7D0, 0xA7D1},
{0xA7D6, 0xA7D7},
{0xA7D8, 0xA7D9},
{0xA7DA, 0xA7DB},
{0xA7DC, 0x019B},
{0xA7F5, 0xA7F6},
{0xFF21, 0xFF41},
{0xFF22, 0xFF42},
{0xFF23, 0xFF43},
{0xFF24, 0xFF44},
{0xFF25, 0xFF45},
{0xFF26, 0xFF46},
{0xFF27, 0xFF47},
{0xFF28, 0xFF48},
{0xFF29, 0xFF49},
{0xFF2A, 0xFF4A},
{0xFF2B, 0xFF4B},
{0xFF2C, 0xFF4C},
{0xFF2D, 0xFF4D},
{0xFF2E, 0xFF4E},
{0xFF2F, 0xFF4F},
{0xFF30, 0xFF50},
{0xFF31, 0xFF51},
{0xFF32, 0xFF52},
{0xFF33, 0xFF53},
{0xFF34, 0xFF54},
{0xFF35, 0xFF55},
{0xFF36, 0xFF56},
{0xFF37, 0xFF57},
{0xFF38, 0xFF58},
{0xFF39, 0xFF59},
{0xFF3A, 0xFF5A},
{0x10400, 0x10428},
{0x10401, 0x10429},
{0x10402, 0x1042A},
{0x10403, 0x1042B},
{0x10404, 0x1042C},
{0x10405, 0x1042D},
{0x10406, 0x1042E},
{0x10407, 0x1042F},
{0x10408, 0x10430},
{0x10409, 0x10431},
{0x1040A, 0x10432},
{0x1040B, 0x10433},
{0x1040C, 0x10434},
{0x1040D, 0x10435},
{0x1040E, 0x10436},
{0x1040F, 0x10437},
{0x10410, 0x10438},
{0x10411, 0x10439},
{0x10412, 0x1043A},
{0x10413, 0x1043B},
{0x10414, 0x1043C},
{0x10415, 0x1043D},
{0x10416, 0x1043E},
{0x10417, 0x1043F},
{0x10418, 0x10440},
{0x10419, 0x10441},
{0x1041A, 0x10442},
{0x1041B, 0x10443},
{0x1041C, 0x10444},
{0x1041D, 0x10445},
{0x1041E, 0x10446},
{0x1041F, 0x10447},
{0x10420, 0x10448},
{0x10421, 0x10449},
{0x10422, 0x1044A},
{0x10423, 0x1044B},
{0x10424, 0x1044C},
{0x10425, 0x1044D},
{0x10426, 0x1044E},
{0x10427, 0x1044F},
{0x104B0, 0x104D8},
{0x104B1, 0x104D9},
{0x104B2, 0x104DA},
{0x104B3, 0x104DB},
{0x104B4, 0x104DC},
{0x104B5, 0x104DD},
{0x104B6, 0x104DE},
{0x104B7, 0x104DF},
{0x104B8, 0x104E0},
{0x104B9, 0x104E1},
{0x104BA, 0x104E2},
{0x104BB, 0x104E3},
{0x104BC, 0x104E4},
{0x104BD, 0x104E5},
{0x104BE, 0x104E6},
{0x104BF, 0x104E7},
{0x104C0, 0x104E8},
{0x104C1, 0x104E9},
{0x104C2, 0x104EA},
{0x104C3, 0x104EB},
{0x104C4, 0x104EC},
{0x104C5, 0x104ED},
{0x104C6, 0x104EE},
{0x104C7, 0x104EF},
{0x104C8, 0x104F0},
{0x104C9, 0x104F1},
{0x104CA, 0x104F2},
{0x104CB, 0x104F3},
{0x104CC, 0x104F4},
{0x104CD, 0x104F5},
{0x104CE, 0x104F6},
{0x104CF, 0x104F7},
{0x104D0, 0x104F8},
{0x104D1, 0x104F9},
{0x104D2, 0x104FA},
{0x104D3, 0x104FB},
{0x10570, 0x10597},
{0x10571, 0x10598},
{0x10572, 0x10599},
{0x10573, 0x1059A},
{0x10574, 0x1059B},
{0x10575, 0x1059C},
{0x10576, 0x1059D},
{0x10577, 0x1059E},
{0x10578, 0x1059F},
{0x10579, 0x105A0},
{0x1057A, 0x105A1},
{0x1057C, 0x105A3},
{0x1057D, 0x105A4},
{0x1057E, 0x105A5},
{0x1057F, 0x105A6},
{0x10580, 0x105A7},
{0x10581, 0x105A8},
{0x10582, 0x105A9},
{0x10583, 0x105AA},
{0x10584, 0x105AB},
{0x10585, 0x105AC},
{0x10586, 0x105AD},
{0x10587, 0x105AE},
{0x10588, 0x105AF},
{0x10589, 0x105B0},
{0x1058A, 0x105B1},
{0x1058C, 0x105B3},
{0x1058D, 0x105B4},
{0x1058E, 0x105B5},
{0x1058F, 0x105B6},
{0x10590, 0x105B7},
{0x10591, 0x105B8},
{0x10592, 0x105B9},
{0x10594, 0x105BB},
{0x10595, 0x105BC},
{0x10C80, 0x10CC0},
{0x10C81, 0x10CC1},
{0x10C82, 0x10CC2},
{0x10C83, 0x10CC3},
{0x10C84, 0x10CC4},
{0x10C85, 0x10CC5},
{0x10C86, 0x10CC6},
{0x10C87, 0x10CC7},
{0x10C88, 0x10CC8},
{0x10C89, 0x10CC9},
{0x10C8A, 0x10CCA},
{0x10C8B, 0x10CCB},
{0x10C8C, 0x10CCC},
{0x10C8D, 0x10CCD},
{0x10C8E, 0x10CCE},
{0x10C8F, 0x10CCF},
{0x10C90, 0x10CD0},
{0x10C91, 0x10CD1},
{0x10C92, 0x10CD2},
{0x10C93, 0x10CD3},
{0x10C94, 0x10CD4},
{0x10C95, 0x10CD5},
{0x10C96, 0x10CD6},
{0x10C97, 0x10CD7},
{0x10C98, 0x10CD8},
{0x10C99, 0x10CD9},
{0x10C9A, 0x10CDA},
{0x10C9B, 0x10CDB},
{0x10C9C, 0x10CDC},
{0x10C9D, 0x10CDD},
{0x10C9E, 0x10CDE},
{0x10C9F, 0x10CDF},
{0x10CA0, 0x10CE0},
{0x10CA1, 0x10CE1},
{0x10CA2, 0x10CE2},
{0x10CA3, 0x10CE3},
{0x10CA4, 0x10CE4},
{0x10CA5, 0x10CE5},
{0x10CA6, 0x10CE6},
{0x10CA7, 0x10CE7},
{0x10CA8, 0x10CE8},
{0x10CA9, 0x10CE9},
{0x10CAA, 0x10CEA},
{0x10CAB, 0x10CEB},
{0x10CAC, 0x10CEC},
{0x10CAD, 0x10CED},
{0x10CAE, 0x10CEE},
{0x10CAF, 0x10CEF},
{0x10CB0, 0x10CF0},
{0x10CB1, 0x10CF1},
{0x10CB2, 0x10CF2},
{0x10D50, 0x10D70},
{0x10D51, 0x10D71},
{0x10D52, 0x10D72},
{0x10D53, 0x10D73},
{0x10D54, 0x10D74},
{0x10D55, 0x10D75},
{0x10D56, 0x10D76},
{0x10D57, 0x10D77},
{0x10D58, 0x10D78},
{0x10D59, 0x10D79},
{0x10D5A, 0x10D7A},
{0x10D5B, 0x10D7B},
{0x10D5C, 0x10D7C},
{0x10D5D, 0x10D7D},
{0x10D5E, 0x10D7E},
{0x10D5F, 0x10D7F},
{0x10D60, 0x10D80},
{0x10D61, 0x10D81},
{0x10D62, 0x10D82},
{0x10D63, 0x10D83},
{0x10D64, 0x10D84},
{0x10D65, 0x10D85},
{0x118A0, 0x118C0},
{0x118A1, 0x118C1},
{0x118A2, 0x118C2},
{0x118A3, 0x118C3},
{0x118A4, 0x118C4},
{0x118A5, 0x118C5},
{0x118A6, 0x118C6},
{0x118A7, 0x118C7},
{0x118A8, 0x118C8},
{0x118A9, 0x118C9},
{0x118AA, 0x118CA},
{0x118AB, 0x118CB},
{0x118AC, 0x118CC},
{0x118AD, 0x118CD},
{0x118AE, 0x118CE},
{0x118AF, 0x118CF},
{0x118B0, 0x118D0},
{0x118B1, 0x118D1},
{0x118B2, 0x118D2},
{0x118B3, 0x118D3},
{0x118B4, 0x118D4},
{0x118B5, 0x118D5},
{0x118B6, 0x118D6},
{0x118B7, 0x118D7},
{0x118B8, 0x118D8},
{0x118B9, 0x118D9},
{0x118BA, 0x118DA},
{0x118BB, 0x118DB},
{0x118BC, 0x118DC},
{0x118BD, 0x118DD},
{0x118BE, 0x118DE},
{0x118BF, 0x118DF},
{0x16E40, 0x16E60},
{0x16E41, 0x16E61},
{0x16E42, 0x16E62},
{0x16E43, 0x16E63},
{0x16E44, 0x16E64},
{0x16E45, 0x16E65},
{0x16E46, 0x16E66},
{0x16E47, 0x16E67},
{0x16E48, 0x16E68},
{0x16E49, 0x16E69},
{0x16E4A, 0x16E6A},
{0x16E4B, 0x16E6B},
{0x16E4C, 0x16E6C},
{0x16E4D, 0x16E6D},
{0x16E4E, 0x16E6E},
{0x16E4F, 0x16E6F},
{0x16E50, 0x16E70},
{0x16E51, 0x16E71},
{0x16E52, 0x16E72},
{0x16E53, 0x16E73},
{0x16E54, 0x16E74},
{0x16E55, 0x16E75},
{0x16E56, 0x16E76},
{0x16E57, 0x16E77},
{0x16E58, 0x16E78},
{0x16E59, 0x16E79},
{0x16E5A, 0x16E7A},
{0x16E5B, 0x16E7B},
{0x16E5C, 0x16E7C},
{0x16E5D, 0x16E7D},
{0x16E5E, 0x16E7E},
{0x16E5F, 0x16E7F},
{0x1E900, 0x1E922},
{0x1E901, 0x1E923},
{0x1E902, 0x1E924},
{0x1E903, 0x1E925},
{0x1E904, 0x1E926},
{0x1E905, 0x1E927},
{0x1E906, 0x1E928},
{0x1E907, 0x1E929},
{0x1E908, 0x1E92A},
{0x1E909, 0x1E92B},
{0x1E90A, 0x1E92C},
{0x1E90B, 0x1E92D},
{0x1E90C, 0x1E92E},
{0x1E90D, 0x1E92F},
{0x1E90E, 0x1E930},
{0x1E90F, 0x1E931},
{0x1E910, 0x1E932},
{0x1E911, 0x1E933},
{0x1E912, 0x1E934},
{0x1E913, 0x1E935},
{0x1E914, 0x1E936},
{0x1E915, 0x1E937},
{0x1E916, 0x1E938},
{0x1E917, 0x1E939},
{0x1E918, 0x1E93A},
{0x1E919, 0x1E93B},
{0x1E91A, 0x1E93C},
{0x1E91B, 0x1E93D},
{0x1E91C, 0x1E93E},
{0x1E91D, 0x1E93F},
{0x1E91E, 0x1E940},
{0x1E91F, 0x1E941},
{0x1E920, 0x1E942},
{0x1E921, 0x1E943},
};

static const size_t g_unicode_cat1_count  = COUNTOF(g_unicode_cat1);
static const size_t g_unicode_upper_count = COUNTOF(g_unicode_upper);
static const size_t g_unicode_lower_count = COUNTOF(g_unicode_lower);

/* Code */

int unicode_category_major(uint32_t cp)
{
	BISECT_RIGHT_DECL(found, idx, 0, g_unicode_cat1_count,
		g_unicode_cat1[i_].to - cp)
	return idx < g_unicode_cat1_count ? g_unicode_cat1[idx].cat1 : 0;
}

uint32_t unicode_upper(uint32_t cp)
{
	BISECT_RIGHT_DECL(found, idx, 0, g_unicode_upper_count,
		g_unicode_upper[i_].from - cp)
	return found ? g_unicode_upper[idx].to : cp;
}

uint32_t unicode_lower(uint32_t cp)
{
	BISECT_RIGHT_DECL(found, idx, 0, g_unicode_lower_count,
		g_unicode_lower[i_].from - cp)
	return found ? g_unicode_lower[idx].to : cp;
}
