/* Copyright 2025-2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 *
 * Implementation of TextRender using FreeType2.
 *
 * Example:
TextRender * tr = textrender_ft2_create("dejavu.ttf", 12);
Image img={0};
textrender_render(tr, &img, NULL, &size, "Sample Text", NULL, TR_RF_IMAGE_ALLOC);
img_free(&img);
textrender_free(tr);
 */
#pragma once
#include "textrender.h"

typedef struct TextRenderFT2Config {
	const char* path;  // File path
	int size;		// Height in pixels
	int bold;		// 1/64 px, try 64
	int slanted;	// 1/1000 relative x shear, try 207
	int index;		// Font index for files with multiple ones
} TextRenderFT2Config;

TextRender* textrender_ft2_create_cfg(const TextRenderFT2Config* cfg);

#define textrender_ft2_create(...) \
	textrender_ft2_create_cfg(&(TextRenderFT2Config){__VA_ARGS__})

extern const TextRenderClass textrender_class_ft2;

#ifdef TEXTRENDER_FT2_IMPL
#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_SIZES_H
#include FT_OUTLINE_H
#include FT_BITMAP_H

typedef struct TextRenderFT2 {
	TextRender B;
	TextRenderFT2Config cfg;
	
	FT_Face ft_face;
	FT_Size ft_size;
	
	// -- Glyph's cache --
	TextRenderGlyph * glyph_missing;

	// ASCII characters: direct
	TextRenderGlyph ** glyph_ascii;  //vector
	unsigned ascii_cp_first, ascii_cp_last;
	
	// Other characters: map
	struct TextRenderFT2GlyphCacheItem {
		unsigned cp;
		TextRenderGlyph * glyph;
	} * glyph_cache;  //vector
} TextRenderFT2;
#endif  //TEXTRENDER_FT2_IMPL
