/* Copyright 2021-2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 *
 * TIFF6 implementation without external dependencies.
 * Faster for saving multi-tiff files than libtiff (2021).
 */
#pragma once
#include "image_io.h"

typedef struct CodecTiff {
	bool		big,  // big endian encoding
		 		be,   // BigTIFF format
				header;
	unsigned	ntag,
				nframe,
				nframe_last;
	uint64_t	o_oifd;
} CodecTiff;

//typedef CodecTiff CodecTiffLoad;
typedef CodecTiff CodecTiffSave;

bool imgio_tiff_detect(Stream* s, const char* fileext);

//int imgio_tiff_load_init(CodecTiffLoad* codec, ImageIO* imgio);

int imgio_tiff_save_init(CodecTiffSave* codec, ImageIO* imgio);

//int imgio_tiff_load_seek(CodecTiffLoad* obj, ImageIO* imgio,
//	long offset, int mode);

//int imgio_tiff_load_op(CodecTiffLoad* codec, ImageIO* imgio, Image* img);

int imgio_tiff_save_op(CodecTiffSave* codec, ImageIO* imgio, Image* img);

void imgio_tiff_free(CodecTiff* codec, ImageIO* imgio);

int imgio_tiff_value_get(CodecTiff* codec, ImageIO* imgio,
	int id, void* buf, unsigned bufsz);

int imgio_tiff_value_set(CodecTiff* codec, ImageIO* imgio,
	int id, const void* buf, unsigned bufsz);

//#define imgio_tiff_load_free imgio_tiff_free
#define imgio_tiff_save_free imgio_tiff_free
//#define imgio_tiff_load_value_get imgio_tiff_value_get
#define imgio_tiff_save_value_get imgio_tiff_value_get
//#define imgio_tiff_load_value_set imgio_tiff_value_set
#define imgio_tiff_save_value_set imgio_tiff_value_set

extern const ImageCodec img_codec_tiff;
extern const ImageCodec img_codec_bigtiff;
