/* Copyright 2021-2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 */
#pragma once
#include "image_io.h"

#ifdef IMGIO_LIBTIFF_IMPL
#include "tiffio.h"

struct CodecLibtiff {
	TIFF* tiff;
	unsigned nframe, nframe_last;
	//unsigned w, h, bypp;
	bool deflate;
};
#endif

typedef struct CodecLibtiff CodecLibtiff;
typedef struct CodecLibtiff CodecLibtiffLoad;
typedef struct CodecLibtiff CodecLibtiffSave;

bool imgio_libtiff_detect(Stream* s, const char* fileext);

int imgio_libtiff_load_init(CodecLibtiffLoad* codec, ImageIO* imgio);

int imgio_libtiff_save_init(CodecLibtiffSave* codec, ImageIO* imgio);

int imgio_libtiff_load_seek(CodecLibtiffLoad* obj, ImageIO* imgio,
	long offset, int mode);

int imgio_libtiff_load_op(CodecLibtiffLoad* codec, ImageIO* imgio, Image* img);

int imgio_libtiff_save_op(CodecLibtiffSave* codec, ImageIO* imgio, Image* img);

void imgio_libtiff_free(CodecLibtiff* codec, ImageIO* imgio);

int imgio_libtiff_value_get(CodecLibtiff* codec, ImageIO* imgio,
	int id, void* buf, unsigned bufsz);

int imgio_libtiff_value_set(CodecLibtiff* codec, ImageIO* imgio,
	int id, const void* buf, unsigned bufsz);

#define imgio_libtiff_load_free imgio_libtiff_free
#define imgio_libtiff_save_free imgio_libtiff_free
#define imgio_libtiff_load_value_get imgio_libtiff_value_get
#define imgio_libtiff_load_value_set imgio_libtiff_value_set
#define imgio_libtiff_save_value_get imgio_libtiff_value_get
#define imgio_libtiff_save_value_set imgio_libtiff_value_set

extern const ImageCodec img_codec_libtiff;
