/* Copyright 2021-2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 */
#pragma once
#include "image_io.h"

#ifdef IMGIO_LIBAV_IMPL
#include <libavformat/avformat.h>
#include <libavcodec/avcodec.h>
#include <libavutil/pixdesc.h>
#include <libswscale/swscale.h>

struct CodecLibAv {
	AVFormatContext * fmtctx;
	AVCodecContext * avctx;
	const AVCodec * codec;
	AVDictionary * codec_options;
	AVPacket * pkt;
	AVFrame * frm;
	
	struct SwsContext * swsctx;
	const AVPixFmtDescriptor * pixdesc;
	unsigned swsctx_w, swsctx_h;
	enum AVPixelFormat swsctx_pixfmt;
	ImgFormat swsctx_imgfmt;
	
	int isv;	//video stream index

	int flags;
	unsigned nframe, nframe_last;
	int64_t target_pts, duration_tb;
};
#endif

enum {
	IMG_LIBAV_PACKET_UNREF		= 0x10,
	IMG_LIBAV_LOAD_RETRY		= 0x20,
	IMG_LIBAV_HEADER_PENDING	= 0x40,
};

typedef struct CodecLibAv CodecLibAv;
typedef struct CodecLibAv CodecLibAvLoad;
typedef struct CodecLibAv CodecLibAvSave;

int imgio_libav_load_init(CodecLibAvLoad* codec, ImageIO* imgio);

void imgio_libav_load_free(CodecLibAvLoad* codec, ImageIO* imgio);

int imgio_libav_load_seek(CodecLibAvLoad* obj, ImageIO* imgio,
	long offset, int mode);

int imgio_libav_load_op(CodecLibAvLoad* codec, ImageIO* imgio, Image* img);

int imgio_libav_value_get(CodecLibAvLoad* codec, ImageIO* imgio,
	int id, void* buf, unsigned bufsz);

int imgio_libav_value_set(CodecLibAvLoad* codec, ImageIO* imgio,
	int id, void* buf, unsigned bufsz);

#define imgio_libav_load_value_get imgio_libav_value_get
#define imgio_libav_load_value_set imgio_libav_value_set
#define imgio_libav_save_value_get imgio_libav_value_get
#define imgio_libav_save_value_set imgio_libav_value_set

int imgio_libav_save_init(CodecLibAvSave* codec, ImageIO* imgio);

void imgio_libav_save_free(CodecLibAvSave* codec, ImageIO* imgio);

int imgio_libav_save_op(CodecLibAvSave* codec, ImageIO* imgio, Image* img);

extern const ImageCodec img_codec_libav;

static inline
CodecLibAvLoad* imgio_libav_load_st_get(ImageIO* imgio) {
	if (!(imgio->codec == &img_codec_libav &&
		  ~imgio->oflags & IMG_OF_SAVE)) return NULL;
	return (CodecLibAvLoad*) imgio->internal;
}

static inline
CodecLibAvSave* imgio_libav_save_st_get(ImageIO* imgio) {
	if (!(imgio->codec == &img_codec_libav &&
		  imgio->oflags & IMG_OF_SAVE)) return NULL;
	return (CodecLibAvSave*) imgio->internal;
}
