/* Copyright 2024-2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 *
 * Reads a sequence of images as one "image" with multiple frames.
 * The sequences is defined by simple numerical patterns in the path.
 * For example, if your provide the path "image0005.png", it will load that image,
 * and then "image0006.png", image0007.png" and so on, until one of such files
 * does not exists.
 */
#pragma once
#include "image_io.h"

enum {
	IMGIO_IMGSEQ_OPEN_ERROR	= 1,
	IMGIO_IMGSEQ_OPEN_DONE	= 2,
};

typedef struct CodecImgSeq {
	ImageIO imgio;
	const ImageCodec* codec;
	char* filename;
	unsigned fn_num_begin, fn_num_len;
	unsigned nframe_base, nframe, nframe_last;
	int flags;
} CodecImgSeq;

int imgio_imgseq_detect_filename(const char* filename,
	unsigned* fn_num_begin, unsigned* fn_num_len);

extern const ImageCodec img_codec_imgseq;
