/* Copyright 2026, Alejandro A. García <aag@zorzal.net>
 * SPDX-License-Identifier: Zlib
 *
 * Helper code to play sounds.
 */
#pragma once
#include <SDL2/SDL.h>
#include "sound.h"

typedef struct AudioSdl {
	//uint8_t	*			buffer;  //vector
	//unsigned			cursor;
	
	SDL_AudioSpec		spec;
	SDL_AudioDeviceID	dev;
	int					sdl_init_flags;
	
	SndFormat			snd_fmt;
	Sound				tmpsnd;

	SDL_AudioCVT		cvt;
	int					cvt_format, cvt_freq, cvt_ch;
} AudioSdl;

void audio_sdl_free(AudioSdl* S);

int audio_sdl_init(AudioSdl* S);

void audio_sdl_stop(AudioSdl* S);

// Convert a sound to the hardware format.
// Can be done inplace (dst = src).
int audio_sdl_sound_convert(AudioSdl* S, Sound* dst, const Sound* src);

int audio_sdl_sound_queue(AudioSdl* S, const Sound* snd, int flags);

enum {
	AUDIO_QF_TRUNCATE = 1,  //Clear queue first
};

int audio_sdl_beep(AudioSdl* S, SndWaveType type, double freq, double amp,
	double dur);

// Return true is the sound is in a format ready to play.
static inline
bool audio_sdl_sound_spec_ready(const AudioSdl* S, const Sound* snd)
{
	const SndFormatAttr * fa = snd_format_attr(snd->format);
	return ((int)fa->size == snd->ss &&  //contiguous
			fa->sdl2 == S->spec.format &&
			(int)snd->freq == S->spec.freq &&
			snd->ch == S->spec.channels);
}

static inline
void audio_sdl_sound_spec_get(const AudioSdl* S,
	unsigned* ch, unsigned* freq, SndFormat* fmt)
{
	if (ch) *ch = S->spec.channels;
	if (freq) *freq = S->spec.freq;
	if (fmt) *fmt = S->snd_fmt;
}
